/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.linearref;

import com.databricks.internal.jts.geom.Coordinate;
import com.databricks.internal.jts.geom.CoordinateList;
import com.databricks.internal.jts.geom.Geometry;
import com.databricks.internal.jts.geom.LineString;
import com.databricks.internal.jts.geom.Lineal;
import com.databricks.internal.jts.linearref.LinearGeometryBuilder;
import com.databricks.internal.jts.linearref.LinearIterator;
import com.databricks.internal.jts.linearref.LinearLocation;
import com.databricks.internal.jts.util.Assert;

class ExtractLineByLocation {
    private Geometry line;

    public static Geometry extract(Geometry line, LinearLocation start, LinearLocation end) {
        ExtractLineByLocation ls = new ExtractLineByLocation(line);
        return ls.extract(start, end);
    }

    public ExtractLineByLocation(Geometry line) {
        this.line = line;
    }

    public Geometry extract(LinearLocation start, LinearLocation end) {
        if (end.compareTo(start) < 0) {
            return this.reverse(this.computeLinear(end, start));
        }
        return this.computeLinear(start, end);
    }

    private Geometry reverse(Geometry linear) {
        if (linear instanceof Lineal) {
            return linear.reverse();
        }
        Assert.shouldNeverReachHere("non-linear geometry encountered");
        return null;
    }

    private LineString computeLine(LinearLocation start, LinearLocation end) {
        Coordinate[] newCoordinateArray;
        Coordinate[] coordinates = this.line.getCoordinates();
        CoordinateList newCoordinates = new CoordinateList();
        int startSegmentIndex = start.getSegmentIndex();
        if (start.getSegmentFraction() > 0.0) {
            ++startSegmentIndex;
        }
        int lastSegmentIndex = end.getSegmentIndex();
        if (end.getSegmentFraction() == 1.0) {
            ++lastSegmentIndex;
        }
        if (lastSegmentIndex >= coordinates.length) {
            lastSegmentIndex = coordinates.length - 1;
        }
        if (!start.isVertex()) {
            newCoordinates.add(start.getCoordinate(this.line));
        }
        for (int i = startSegmentIndex; i <= lastSegmentIndex; ++i) {
            newCoordinates.add(coordinates[i]);
        }
        if (!end.isVertex()) {
            newCoordinates.add(end.getCoordinate(this.line));
        }
        if (newCoordinates.size() <= 0) {
            newCoordinates.add(start.getCoordinate(this.line));
        }
        if ((newCoordinateArray = newCoordinates.toCoordinateArray()).length <= 1) {
            newCoordinateArray = new Coordinate[]{newCoordinateArray[0], newCoordinateArray[0]};
        }
        return this.line.getFactory().createLineString(newCoordinateArray);
    }

    private Geometry computeLinear(LinearLocation start, LinearLocation end) {
        LinearGeometryBuilder builder = new LinearGeometryBuilder(this.line.getFactory());
        builder.setFixInvalidLines(true);
        if (!start.isVertex()) {
            builder.add(start.getCoordinate(this.line));
        }
        LinearIterator it = new LinearIterator(this.line, start);
        while (it.hasNext() && end.compareLocationValues(it.getComponentIndex(), it.getVertexIndex(), 0.0) >= 0) {
            Coordinate pt = it.getSegmentStart();
            builder.add(pt);
            if (it.isEndOfLine()) {
                builder.endLine();
            }
            it.next();
        }
        if (!end.isVertex()) {
            builder.add(end.getCoordinate(this.line));
        }
        return builder.getGeometry();
    }
}

