/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.noding;

import com.databricks.internal.jts.algorithm.LineIntersector;
import com.databricks.internal.jts.geom.Coordinate;
import com.databricks.internal.jts.geom.impl.CoordinateArraySequence;
import com.databricks.internal.jts.io.WKTWriter;
import com.databricks.internal.jts.noding.NodableSegmentString;
import com.databricks.internal.jts.noding.Octant;
import com.databricks.internal.jts.noding.SegmentNode;
import com.databricks.internal.jts.noding.SegmentNodeList;
import com.databricks.internal.jts.noding.SegmentString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class NodedSegmentString
implements NodableSegmentString {
    private SegmentNodeList nodeList = new SegmentNodeList(this);
    private Coordinate[] pts;
    private Object data;

    public static List getNodedSubstrings(Collection segStrings) {
        ArrayList resultEdgelist = new ArrayList();
        NodedSegmentString.getNodedSubstrings(segStrings, resultEdgelist);
        return resultEdgelist;
    }

    public static void getNodedSubstrings(Collection segStrings, Collection resultEdgelist) {
        for (Object segString : segStrings) {
            NodedSegmentString ss = (NodedSegmentString)segString;
            ss.getNodeList().addSplitEdges(resultEdgelist);
        }
    }

    public NodedSegmentString(Coordinate[] pts, Object data) {
        this.pts = pts;
        this.data = data;
    }

    public NodedSegmentString(SegmentString ss) {
        this.pts = ss.getCoordinates();
        this.data = ss.getData();
    }

    @Override
    public Object getData() {
        return this.data;
    }

    @Override
    public void setData(Object data) {
        this.data = data;
    }

    public SegmentNodeList getNodeList() {
        return this.nodeList;
    }

    @Override
    public int size() {
        return this.pts.length;
    }

    @Override
    public Coordinate getCoordinate(int i) {
        return this.pts[i];
    }

    @Override
    public Coordinate[] getCoordinates() {
        return this.pts;
    }

    public Coordinate[] getNodedCoordinates() {
        return this.nodeList.getSplitCoordinates();
    }

    @Override
    public boolean isClosed() {
        return this.pts[0].equals(this.pts[this.pts.length - 1]);
    }

    public boolean hasNodes() {
        return this.nodeList.size() > 0;
    }

    public int getSegmentOctant(int index) {
        if (index == this.pts.length - 1) {
            return -1;
        }
        return this.safeOctant(this.getCoordinate(index), this.getCoordinate(index + 1));
    }

    private int safeOctant(Coordinate p0, Coordinate p1) {
        if (p0.equals2D(p1)) {
            return 0;
        }
        return Octant.octant(p0, p1);
    }

    public void addIntersections(LineIntersector li, int segmentIndex, int geomIndex) {
        for (int i = 0; i < li.getIntersectionNum(); ++i) {
            this.addIntersection(li, segmentIndex, geomIndex, i);
        }
    }

    public void addIntersection(LineIntersector li, int segmentIndex, int geomIndex, int intIndex) {
        Coordinate intPt = li.getIntersection(intIndex).copy();
        this.addIntersection(intPt, segmentIndex);
    }

    @Override
    public void addIntersection(Coordinate intPt, int segmentIndex) {
        this.addIntersectionNode(intPt, segmentIndex);
    }

    public SegmentNode addIntersectionNode(Coordinate intPt, int segmentIndex) {
        Coordinate nextPt;
        int normalizedSegmentIndex = segmentIndex;
        int nextSegIndex = normalizedSegmentIndex + 1;
        if (nextSegIndex < this.pts.length && intPt.equals2D(nextPt = this.pts[nextSegIndex])) {
            normalizedSegmentIndex = nextSegIndex;
        }
        SegmentNode ei = this.nodeList.add(intPt, normalizedSegmentIndex);
        return ei;
    }

    public String toString() {
        return WKTWriter.toLineString(new CoordinateArraySequence(this.pts));
    }
}

