/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.operation.polygonize;

import com.databricks.internal.jts.geom.Envelope;
import com.databricks.internal.jts.index.SpatialIndex;
import com.databricks.internal.jts.index.strtree.STRtree;
import com.databricks.internal.jts.operation.polygonize.EdgeRing;
import java.util.List;

public class HoleAssigner {
    private List<EdgeRing> shells;
    private SpatialIndex shellIndex;

    public static void assignHolesToShells(List<EdgeRing> holes, List<EdgeRing> shells) {
        HoleAssigner assigner = new HoleAssigner(shells);
        assigner.assignHolesToShells(holes);
    }

    public HoleAssigner(List<EdgeRing> shells) {
        this.shells = shells;
        this.buildIndex();
    }

    private void buildIndex() {
        this.shellIndex = new STRtree();
        for (EdgeRing shell : this.shells) {
            this.shellIndex.insert(shell.getRing().getEnvelopeInternal(), shell);
        }
    }

    public void assignHolesToShells(List<EdgeRing> holeList) {
        for (EdgeRing holeER : holeList) {
            this.assignHoleToShell(holeER);
        }
    }

    private void assignHoleToShell(EdgeRing holeER) {
        EdgeRing shell = this.findShellContaining(holeER);
        if (shell != null) {
            shell.addHole(holeER);
        }
    }

    private List<EdgeRing> queryOverlappingShells(Envelope ringEnv) {
        return this.shellIndex.query(ringEnv);
    }

    private EdgeRing findShellContaining(EdgeRing testEr) {
        Envelope testEnv = testEr.getRing().getEnvelopeInternal();
        List<EdgeRing> candidateShells = this.queryOverlappingShells(testEnv);
        return EdgeRing.findEdgeRingContaining(testEr, candidateShells);
    }
}

