/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.precision;

import com.databricks.internal.jts.geom.Geometry;
import com.databricks.internal.jts.geom.GeometryFactory;
import com.databricks.internal.jts.geom.PrecisionModel;
import com.databricks.internal.jts.geom.util.GeometryEditor;
import com.databricks.internal.jts.precision.PointwisePrecisionReducerTransformer;
import com.databricks.internal.jts.precision.PrecisionReducerTransformer;

public class GeometryPrecisionReducer {
    private PrecisionModel targetPM;
    private boolean removeCollapsed = true;
    private boolean changePrecisionModel = false;
    private boolean isPointwise = false;

    public static Geometry reduce(Geometry g2, PrecisionModel precModel) {
        GeometryPrecisionReducer reducer = new GeometryPrecisionReducer(precModel);
        return reducer.reduce(g2);
    }

    public static Geometry reduceKeepCollapsed(Geometry geom, PrecisionModel pm) {
        GeometryPrecisionReducer reducer = new GeometryPrecisionReducer(pm);
        reducer.setRemoveCollapsedComponents(false);
        return reducer.reduce(geom);
    }

    public static Geometry reducePointwise(Geometry g2, PrecisionModel precModel) {
        GeometryPrecisionReducer reducer = new GeometryPrecisionReducer(precModel);
        reducer.setPointwise(true);
        return reducer.reduce(g2);
    }

    public GeometryPrecisionReducer(PrecisionModel pm) {
        this.targetPM = pm;
    }

    public void setRemoveCollapsedComponents(boolean removeCollapsed) {
        this.removeCollapsed = removeCollapsed;
    }

    public void setChangePrecisionModel(boolean changePrecisionModel) {
        this.changePrecisionModel = changePrecisionModel;
    }

    public void setPointwise(boolean isPointwise) {
        this.isPointwise = isPointwise;
    }

    public Geometry reduce(Geometry geom) {
        Geometry reduced = this.isPointwise ? PointwisePrecisionReducerTransformer.reduce(geom, this.targetPM) : PrecisionReducerTransformer.reduce(geom, this.targetPM, this.removeCollapsed);
        if (this.changePrecisionModel) {
            return this.changePM(reduced, this.targetPM);
        }
        return reduced;
    }

    private Geometry changePM(Geometry geom, PrecisionModel newPM) {
        GeometryEditor geomEditor = this.createEditor(geom.getFactory(), newPM);
        return geomEditor.edit(geom, new GeometryEditor.NoOpGeometryOperation());
    }

    private GeometryEditor createEditor(GeometryFactory geomFactory, PrecisionModel newPM) {
        if (geomFactory.getPrecisionModel() == newPM) {
            return new GeometryEditor();
        }
        GeometryFactory newFactory = this.createFactory(geomFactory, newPM);
        GeometryEditor geomEdit = new GeometryEditor(newFactory);
        return geomEdit;
    }

    private GeometryFactory createFactory(GeometryFactory inputFactory, PrecisionModel pm) {
        GeometryFactory newFactory = new GeometryFactory(pm, inputFactory.getSRID(), inputFactory.getCoordinateSequenceFactory());
        return newFactory;
    }
}

