/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.simplify;

import com.databricks.internal.jts.geom.Coordinate;
import com.databricks.internal.jts.geom.LineSegment;
import com.databricks.internal.jts.geom.LineString;
import com.databricks.internal.jts.geom.LinearRing;
import com.databricks.internal.jts.simplify.TaggedLineSegment;
import java.util.ArrayList;
import java.util.List;

class TaggedLineString {
    private LineString parentLine;
    private TaggedLineSegment[] segs;
    private List<LineSegment> resultSegs = new ArrayList<LineSegment>();
    private int minimumSize;
    private boolean isRing = true;

    public TaggedLineString(LineString parentLine, int minimumSize, boolean isRing) {
        this.parentLine = parentLine;
        this.minimumSize = minimumSize;
        this.isRing = isRing;
        this.init();
    }

    public boolean isRing() {
        return this.isRing;
    }

    public int getMinimumSize() {
        return this.minimumSize;
    }

    public LineString getParent() {
        return this.parentLine;
    }

    public Coordinate[] getParentCoordinates() {
        return this.parentLine.getCoordinates();
    }

    public Coordinate[] getResultCoordinates() {
        return TaggedLineString.extractCoordinates(this.resultSegs);
    }

    public Coordinate getCoordinate(int i) {
        return this.parentLine.getCoordinateN(i);
    }

    public int size() {
        return this.parentLine.getNumPoints();
    }

    public Coordinate getComponentPoint() {
        return this.getParentCoordinates()[1];
    }

    public int getResultSize() {
        int resultSegsSize = this.resultSegs.size();
        return resultSegsSize == 0 ? 0 : resultSegsSize + 1;
    }

    public TaggedLineSegment getSegment(int i) {
        return this.segs[i];
    }

    public LineSegment getResultSegment(int i) {
        int index = i;
        if (i < 0) {
            index = this.resultSegs.size() + i;
        }
        return this.resultSegs.get(index);
    }

    private void init() {
        Coordinate[] pts = this.parentLine.getCoordinates();
        this.segs = new TaggedLineSegment[pts.length - 1];
        for (int i = 0; i < pts.length - 1; ++i) {
            TaggedLineSegment seg;
            this.segs[i] = seg = new TaggedLineSegment(pts[i], pts[i + 1], this.parentLine, i);
        }
    }

    public TaggedLineSegment[] getSegments() {
        return this.segs;
    }

    public void addToResult(LineSegment seg) {
        this.resultSegs.add(seg);
    }

    public LineString asLineString() {
        return this.parentLine.getFactory().createLineString(TaggedLineString.extractCoordinates(this.resultSegs));
    }

    public LinearRing asLinearRing() {
        return this.parentLine.getFactory().createLinearRing(TaggedLineString.extractCoordinates(this.resultSegs));
    }

    private static Coordinate[] extractCoordinates(List<LineSegment> segs) {
        Coordinate[] pts = new Coordinate[segs.size() + 1];
        LineSegment seg = null;
        for (int i = 0; i < segs.size(); ++i) {
            seg = segs.get(i);
            pts[i] = seg.p0;
        }
        pts[pts.length - 1] = seg.p1;
        return pts;
    }

    LineSegment removeRingEndpoint() {
        LineSegment firstSeg = this.resultSegs.get(0);
        LineSegment lastSeg = this.resultSegs.get(this.resultSegs.size() - 1);
        firstSeg.p0 = lastSeg.p0;
        this.resultSegs.remove(this.resultSegs.size() - 1);
        return firstSeg;
    }
}

