/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.core.oauth;

import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.http.HttpClient;
import com.databricks.internal.sdk.core.oauth.AuthParameterPosition;
import com.databricks.internal.sdk.core.oauth.Token;
import com.databricks.internal.sdk.core.oauth.TokenCache;
import com.databricks.internal.sdk.core.oauth.TokenEndpointClient;
import com.databricks.internal.sdk.core.oauth.TokenSource;
import com.databricks.internal.slf4j.Logger;
import com.databricks.internal.slf4j.LoggerFactory;
import java.util.HashMap;
import java.util.Optional;

public class SessionCredentialsTokenSource
implements TokenSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionCredentialsTokenSource.class);
    private Token token;
    private final HttpClient hc;
    private final String tokenUrl;
    private final Optional<String> redirectUrl;
    private final String clientId;
    private final String clientSecret;
    private final Optional<TokenCache> tokenCache;

    public SessionCredentialsTokenSource(Token token, HttpClient hc, String tokenUrl, String clientId, String clientSecret, Optional<String> redirectUrl, Optional<TokenCache> tokenCache) {
        this.token = token;
        this.hc = hc;
        this.tokenUrl = tokenUrl;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.redirectUrl = redirectUrl;
        this.tokenCache = tokenCache;
    }

    @Override
    public Token getToken() {
        if (this.token == null) {
            throw new DatabricksException("oauth2: token is not set");
        }
        String refreshToken = this.token.getRefreshToken();
        if (refreshToken == null) {
            throw new DatabricksException("oauth2: token expired and refresh token is not set");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("grant_type", "refresh_token");
        params.put("refresh_token", refreshToken);
        HashMap<String, String> headers = new HashMap<String, String>();
        if (this.tokenUrl.contains("microsoft")) {
            this.redirectUrl.ifPresent(url -> headers.put("Origin", (String)url));
        }
        this.token = TokenEndpointClient.retrieveToken(this.hc, this.clientId, this.clientSecret, this.tokenUrl, params, headers, AuthParameterPosition.BODY);
        this.tokenCache.ifPresent(cache -> {
            cache.save(this.token);
            LOGGER.debug("Saved refreshed token to cache");
        });
        return this.token;
    }
}

