/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.catalog;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.catalog.CatalogInfo;
import com.databricks.internal.sdk.service.catalog.CatalogsImpl;
import com.databricks.internal.sdk.service.catalog.CatalogsService;
import com.databricks.internal.sdk.service.catalog.CreateCatalog;
import com.databricks.internal.sdk.service.catalog.DeleteCatalogRequest;
import com.databricks.internal.sdk.service.catalog.GetCatalogRequest;
import com.databricks.internal.sdk.service.catalog.ListCatalogsRequest;
import com.databricks.internal.sdk.service.catalog.ListCatalogsResponse;
import com.databricks.internal.sdk.service.catalog.UpdateCatalog;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Paginator;
import com.databricks.internal.slf4j.Logger;
import com.databricks.internal.slf4j.LoggerFactory;

@Generated
public class CatalogsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(CatalogsAPI.class);
    private final CatalogsService impl;

    public CatalogsAPI(ApiClient apiClient) {
        this.impl = new CatalogsImpl(apiClient);
    }

    public CatalogsAPI(CatalogsService mock) {
        this.impl = mock;
    }

    public CatalogInfo create(CreateCatalog request) {
        return this.impl.create(request);
    }

    public void delete(String name) {
        this.delete(new DeleteCatalogRequest().setName(name));
    }

    public void delete(DeleteCatalogRequest request) {
        this.impl.delete(request);
    }

    public CatalogInfo get(String name) {
        return this.get(new GetCatalogRequest().setName(name));
    }

    public CatalogInfo get(GetCatalogRequest request) {
        return this.impl.get(request);
    }

    public Iterable<CatalogInfo> list(ListCatalogsRequest request) {
        return new Paginator(request, this.impl::list, ListCatalogsResponse::getCatalogs, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public CatalogInfo update(UpdateCatalog request) {
        return this.impl.update(request);
    }

    public CatalogsService impl() {
        return this.impl;
    }
}

