/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.catalog;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.http.Request;
import com.databricks.internal.sdk.service.catalog.CreateVolumeRequestContent;
import com.databricks.internal.sdk.service.catalog.DeleteVolumeRequest;
import com.databricks.internal.sdk.service.catalog.ListVolumesRequest;
import com.databricks.internal.sdk.service.catalog.ListVolumesResponseContent;
import com.databricks.internal.sdk.service.catalog.ReadVolumeRequest;
import com.databricks.internal.sdk.service.catalog.UpdateVolumeRequestContent;
import com.databricks.internal.sdk.service.catalog.VolumeInfo;
import com.databricks.internal.sdk.service.catalog.VolumesService;
import com.databricks.internal.sdk.support.Generated;
import java.io.IOException;

@Generated
class VolumesImpl
implements VolumesService {
    private final ApiClient apiClient;

    public VolumesImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public VolumeInfo create(CreateVolumeRequestContent request) {
        String path = "/api/2.1/unity-catalog/volumes";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, VolumeInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeleteVolumeRequest request) {
        String path = String.format("/api/2.1/unity-catalog/volumes/%s", request.getName());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListVolumesResponseContent list(ListVolumesRequest request) {
        String path = "/api/2.1/unity-catalog/volumes";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListVolumesResponseContent.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public VolumeInfo read(ReadVolumeRequest request) {
        String path = String.format("/api/2.1/unity-catalog/volumes/%s", request.getName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, VolumeInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public VolumeInfo update(UpdateVolumeRequestContent request) {
        String path = String.format("/api/2.1/unity-catalog/volumes/%s", request.getName());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, VolumeInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

