/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.compute;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.compute.ClusterLibraryStatuses;
import com.databricks.internal.sdk.service.compute.ClusterStatus;
import com.databricks.internal.sdk.service.compute.InstallLibraries;
import com.databricks.internal.sdk.service.compute.LibrariesImpl;
import com.databricks.internal.sdk.service.compute.LibrariesService;
import com.databricks.internal.sdk.service.compute.LibraryFullStatus;
import com.databricks.internal.sdk.service.compute.ListAllClusterLibraryStatusesResponse;
import com.databricks.internal.sdk.service.compute.UninstallLibraries;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Paginator;
import com.databricks.internal.slf4j.Logger;
import com.databricks.internal.slf4j.LoggerFactory;

@Generated
public class LibrariesAPI {
    private static final Logger LOG = LoggerFactory.getLogger(LibrariesAPI.class);
    private final LibrariesService impl;

    public LibrariesAPI(ApiClient apiClient) {
        this.impl = new LibrariesImpl(apiClient);
    }

    public LibrariesAPI(LibrariesService mock) {
        this.impl = mock;
    }

    public Iterable<ClusterLibraryStatuses> allClusterStatuses() {
        return new Paginator(null, v -> this.impl.allClusterStatuses(), ListAllClusterLibraryStatusesResponse::getStatuses, response -> null);
    }

    public Iterable<LibraryFullStatus> clusterStatus(String clusterId) {
        return this.clusterStatus(new ClusterStatus().setClusterId(clusterId));
    }

    public Iterable<LibraryFullStatus> clusterStatus(ClusterStatus request) {
        return new Paginator(request, this.impl::clusterStatus, ClusterLibraryStatuses::getLibraryStatuses, response -> null);
    }

    public void install(InstallLibraries request) {
        this.impl.install(request);
    }

    public void uninstall(UninstallLibraries request) {
        this.impl.uninstall(request);
    }

    public LibrariesService impl() {
        return this.impl;
    }
}

