/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.files;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.files.AddBlock;
import com.databricks.internal.sdk.service.files.Close;
import com.databricks.internal.sdk.service.files.Create;
import com.databricks.internal.sdk.service.files.CreateResponse;
import com.databricks.internal.sdk.service.files.DbfsImpl;
import com.databricks.internal.sdk.service.files.DbfsService;
import com.databricks.internal.sdk.service.files.Delete;
import com.databricks.internal.sdk.service.files.FileInfo;
import com.databricks.internal.sdk.service.files.GetStatusRequest;
import com.databricks.internal.sdk.service.files.ListDbfsRequest;
import com.databricks.internal.sdk.service.files.ListStatusResponse;
import com.databricks.internal.sdk.service.files.MkDirs;
import com.databricks.internal.sdk.service.files.Move;
import com.databricks.internal.sdk.service.files.Put;
import com.databricks.internal.sdk.service.files.ReadDbfsRequest;
import com.databricks.internal.sdk.service.files.ReadResponse;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Paginator;
import com.databricks.internal.slf4j.Logger;
import com.databricks.internal.slf4j.LoggerFactory;

@Generated
public class DbfsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(DbfsAPI.class);
    private final DbfsService impl;

    public DbfsAPI(ApiClient apiClient) {
        this.impl = new DbfsImpl(apiClient);
    }

    public DbfsAPI(DbfsService mock) {
        this.impl = mock;
    }

    public void addBlock(AddBlock request) {
        this.impl.addBlock(request);
    }

    public void close(long handle) {
        this.close(new Close().setHandle(handle));
    }

    public void close(Close request) {
        this.impl.close(request);
    }

    public CreateResponse create(Create request) {
        return this.impl.create(request);
    }

    public void delete(Delete request) {
        this.impl.delete(request);
    }

    public FileInfo getStatus(String path) {
        return this.getStatus(new GetStatusRequest().setPath(path));
    }

    public FileInfo getStatus(GetStatusRequest request) {
        return this.impl.getStatus(request);
    }

    public Iterable<FileInfo> list(String path) {
        return this.list(new ListDbfsRequest().setPath(path));
    }

    public Iterable<FileInfo> list(ListDbfsRequest request) {
        return new Paginator(request, this.impl::list, ListStatusResponse::getFiles, response -> null);
    }

    public void mkdirs(String path) {
        this.mkdirs(new MkDirs().setPath(path));
    }

    public void mkdirs(MkDirs request) {
        this.impl.mkdirs(request);
    }

    public void move(Move request) {
        this.impl.move(request);
    }

    public void put(Put request) {
        this.impl.put(request);
    }

    public ReadResponse read(String path) {
        return this.read(new ReadDbfsRequest().setPath(path));
    }

    public ReadResponse read(ReadDbfsRequest request) {
        return this.impl.read(request);
    }

    public DbfsService impl() {
        return this.impl;
    }
}

