/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.ml;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.ml.CreateOnlineStoreRequest;
import com.databricks.internal.sdk.service.ml.DeleteOnlineStoreRequest;
import com.databricks.internal.sdk.service.ml.FeatureStoreImpl;
import com.databricks.internal.sdk.service.ml.FeatureStoreService;
import com.databricks.internal.sdk.service.ml.GetOnlineStoreRequest;
import com.databricks.internal.sdk.service.ml.ListOnlineStoresRequest;
import com.databricks.internal.sdk.service.ml.ListOnlineStoresResponse;
import com.databricks.internal.sdk.service.ml.OnlineStore;
import com.databricks.internal.sdk.service.ml.PublishTableRequest;
import com.databricks.internal.sdk.service.ml.PublishTableResponse;
import com.databricks.internal.sdk.service.ml.UpdateOnlineStoreRequest;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Paginator;
import com.databricks.internal.slf4j.Logger;
import com.databricks.internal.slf4j.LoggerFactory;

@Generated
public class FeatureStoreAPI {
    private static final Logger LOG = LoggerFactory.getLogger(FeatureStoreAPI.class);
    private final FeatureStoreService impl;

    public FeatureStoreAPI(ApiClient apiClient) {
        this.impl = new FeatureStoreImpl(apiClient);
    }

    public FeatureStoreAPI(FeatureStoreService mock) {
        this.impl = mock;
    }

    public OnlineStore createOnlineStore(CreateOnlineStoreRequest request) {
        return this.impl.createOnlineStore(request);
    }

    public void deleteOnlineStore(String name) {
        this.deleteOnlineStore(new DeleteOnlineStoreRequest().setName(name));
    }

    public void deleteOnlineStore(DeleteOnlineStoreRequest request) {
        this.impl.deleteOnlineStore(request);
    }

    public OnlineStore getOnlineStore(String name) {
        return this.getOnlineStore(new GetOnlineStoreRequest().setName(name));
    }

    public OnlineStore getOnlineStore(GetOnlineStoreRequest request) {
        return this.impl.getOnlineStore(request);
    }

    public Iterable<OnlineStore> listOnlineStores(ListOnlineStoresRequest request) {
        return new Paginator(request, this.impl::listOnlineStores, ListOnlineStoresResponse::getOnlineStores, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public PublishTableResponse publishTable(PublishTableRequest request) {
        return this.impl.publishTable(request);
    }

    public OnlineStore updateOnlineStore(UpdateOnlineStoreRequest request) {
        return this.impl.updateOnlineStore(request);
    }

    public FeatureStoreService impl() {
        return this.impl;
    }
}

