/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.oauth2;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.oauth2.CreateServicePrincipalSecretRequest;
import com.databricks.internal.sdk.service.oauth2.CreateServicePrincipalSecretResponse;
import com.databricks.internal.sdk.service.oauth2.DeleteServicePrincipalSecretRequest;
import com.databricks.internal.sdk.service.oauth2.ListServicePrincipalSecretsRequest;
import com.databricks.internal.sdk.service.oauth2.ListServicePrincipalSecretsResponse;
import com.databricks.internal.sdk.service.oauth2.SecretInfo;
import com.databricks.internal.sdk.service.oauth2.ServicePrincipalSecretsProxyImpl;
import com.databricks.internal.sdk.service.oauth2.ServicePrincipalSecretsProxyService;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Paginator;
import com.databricks.internal.slf4j.Logger;
import com.databricks.internal.slf4j.LoggerFactory;

@Generated
public class ServicePrincipalSecretsProxyAPI {
    private static final Logger LOG = LoggerFactory.getLogger(ServicePrincipalSecretsProxyAPI.class);
    private final ServicePrincipalSecretsProxyService impl;

    public ServicePrincipalSecretsProxyAPI(ApiClient apiClient) {
        this.impl = new ServicePrincipalSecretsProxyImpl(apiClient);
    }

    public ServicePrincipalSecretsProxyAPI(ServicePrincipalSecretsProxyService mock) {
        this.impl = mock;
    }

    public CreateServicePrincipalSecretResponse create(CreateServicePrincipalSecretRequest request) {
        return this.impl.create(request);
    }

    public void delete(String servicePrincipalId, String secretId) {
        this.delete(new DeleteServicePrincipalSecretRequest().setServicePrincipalId(servicePrincipalId).setSecretId(secretId));
    }

    public void delete(DeleteServicePrincipalSecretRequest request) {
        this.impl.delete(request);
    }

    public Iterable<SecretInfo> list(String servicePrincipalId) {
        return this.list(new ListServicePrincipalSecretsRequest().setServicePrincipalId(servicePrincipalId));
    }

    public Iterable<SecretInfo> list(ListServicePrincipalSecretsRequest request) {
        return new Paginator(request, this.impl::list, ListServicePrincipalSecretsResponse::getSecrets, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public ServicePrincipalSecretsProxyService impl() {
        return this.impl;
    }
}

