/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.tags;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.tags.CreateTagPolicyRequest;
import com.databricks.internal.sdk.service.tags.DeleteTagPolicyRequest;
import com.databricks.internal.sdk.service.tags.GetTagPolicyRequest;
import com.databricks.internal.sdk.service.tags.ListTagPoliciesRequest;
import com.databricks.internal.sdk.service.tags.ListTagPoliciesResponse;
import com.databricks.internal.sdk.service.tags.TagPoliciesImpl;
import com.databricks.internal.sdk.service.tags.TagPoliciesService;
import com.databricks.internal.sdk.service.tags.TagPolicy;
import com.databricks.internal.sdk.service.tags.UpdateTagPolicyRequest;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Paginator;
import com.databricks.internal.slf4j.Logger;
import com.databricks.internal.slf4j.LoggerFactory;

@Generated
public class TagPoliciesAPI {
    private static final Logger LOG = LoggerFactory.getLogger(TagPoliciesAPI.class);
    private final TagPoliciesService impl;

    public TagPoliciesAPI(ApiClient apiClient) {
        this.impl = new TagPoliciesImpl(apiClient);
    }

    public TagPoliciesAPI(TagPoliciesService mock) {
        this.impl = mock;
    }

    public TagPolicy createTagPolicy(CreateTagPolicyRequest request) {
        return this.impl.createTagPolicy(request);
    }

    public void deleteTagPolicy(String tagKey) {
        this.deleteTagPolicy(new DeleteTagPolicyRequest().setTagKey(tagKey));
    }

    public void deleteTagPolicy(DeleteTagPolicyRequest request) {
        this.impl.deleteTagPolicy(request);
    }

    public TagPolicy getTagPolicy(String tagKey) {
        return this.getTagPolicy(new GetTagPolicyRequest().setTagKey(tagKey));
    }

    public TagPolicy getTagPolicy(GetTagPolicyRequest request) {
        return this.impl.getTagPolicy(request);
    }

    public Iterable<TagPolicy> listTagPolicies(ListTagPoliciesRequest request) {
        return new Paginator(request, this.impl::listTagPolicies, ListTagPoliciesResponse::getTagPolicies, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public TagPolicy updateTagPolicy(UpdateTagPolicyRequest request) {
        return this.impl.updateTagPolicy(request);
    }

    public TagPoliciesService impl() {
        return this.impl;
    }
}

