/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.workspace;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.http.Request;
import com.databricks.internal.sdk.service.workspace.Delete;
import com.databricks.internal.sdk.service.workspace.ExportRequest;
import com.databricks.internal.sdk.service.workspace.ExportResponse;
import com.databricks.internal.sdk.service.workspace.GetStatusRequest;
import com.databricks.internal.sdk.service.workspace.GetWorkspaceObjectPermissionLevelsRequest;
import com.databricks.internal.sdk.service.workspace.GetWorkspaceObjectPermissionLevelsResponse;
import com.databricks.internal.sdk.service.workspace.GetWorkspaceObjectPermissionsRequest;
import com.databricks.internal.sdk.service.workspace.Import;
import com.databricks.internal.sdk.service.workspace.ListResponse;
import com.databricks.internal.sdk.service.workspace.ListWorkspaceRequest;
import com.databricks.internal.sdk.service.workspace.Mkdirs;
import com.databricks.internal.sdk.service.workspace.ObjectInfo;
import com.databricks.internal.sdk.service.workspace.WorkspaceObjectPermissions;
import com.databricks.internal.sdk.service.workspace.WorkspaceObjectPermissionsRequest;
import com.databricks.internal.sdk.service.workspace.WorkspaceService;
import com.databricks.internal.sdk.support.Generated;
import java.io.IOException;

@Generated
class WorkspaceImpl
implements WorkspaceService {
    private final ApiClient apiClient;

    public WorkspaceImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public void delete(Delete request) {
        String path = "/api/2.0/workspace/delete";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ExportResponse export(ExportRequest request) {
        String path = "/api/2.0/workspace/export";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ExportResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public GetWorkspaceObjectPermissionLevelsResponse getPermissionLevels(GetWorkspaceObjectPermissionLevelsRequest request) {
        String path = String.format("/api/2.0/permissions/%s/%s/permissionLevels", request.getWorkspaceObjectType(), request.getWorkspaceObjectId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, GetWorkspaceObjectPermissionLevelsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public WorkspaceObjectPermissions getPermissions(GetWorkspaceObjectPermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/%s/%s", request.getWorkspaceObjectType(), request.getWorkspaceObjectId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, WorkspaceObjectPermissions.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ObjectInfo getStatus(GetStatusRequest request) {
        String path = "/api/2.0/workspace/get-status";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ObjectInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void importContent(Import request) {
        String path = "/api/2.0/workspace/import";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListResponse list(ListWorkspaceRequest request) {
        String path = "/api/2.0/workspace/list";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void mkdirs(Mkdirs request) {
        String path = "/api/2.0/workspace/mkdirs";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public WorkspaceObjectPermissions setPermissions(WorkspaceObjectPermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/%s/%s", request.getWorkspaceObjectType(), request.getWorkspaceObjectId());
        try {
            Request req = new Request("PUT", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, WorkspaceObjectPermissions.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public WorkspaceObjectPermissions updatePermissions(WorkspaceObjectPermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/%s/%s", request.getWorkspaceObjectType(), request.getWorkspaceObjectId());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, WorkspaceObjectPermissions.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

