/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.api.impl;

import com.databricks.internal.google.common.annotations.VisibleForTesting;
import com.databricks.jdbc.api.IDatabricksConnection;
import com.databricks.jdbc.api.IDatabricksStatement;
import com.databricks.jdbc.api.impl.DatabricksDatabaseMetaData;
import com.databricks.jdbc.api.impl.DatabricksPreparedStatement;
import com.databricks.jdbc.api.impl.DatabricksSession;
import com.databricks.jdbc.api.impl.DatabricksStatement;
import com.databricks.jdbc.api.internal.IDatabricksConnectionContext;
import com.databricks.jdbc.api.internal.IDatabricksConnectionInternal;
import com.databricks.jdbc.api.internal.IDatabricksSession;
import com.databricks.jdbc.api.internal.IDatabricksStatementInternal;
import com.databricks.jdbc.common.DatabricksClientConfiguratorManager;
import com.databricks.jdbc.common.DatabricksJdbcConstants;
import com.databricks.jdbc.common.safe.DatabricksDriverFeatureFlagsContextFactory;
import com.databricks.jdbc.common.util.DatabricksThreadContextHolder;
import com.databricks.jdbc.common.util.UserAgentManager;
import com.databricks.jdbc.common.util.ValidationUtil;
import com.databricks.jdbc.dbclient.IDatabricksClient;
import com.databricks.jdbc.dbclient.impl.common.SessionId;
import com.databricks.jdbc.dbclient.impl.common.StatementId;
import com.databricks.jdbc.dbclient.impl.http.DatabricksHttpClientFactory;
import com.databricks.jdbc.exception.DatabricksSQLClientInfoException;
import com.databricks.jdbc.exception.DatabricksSQLException;
import com.databricks.jdbc.exception.DatabricksSQLFeatureNotImplementedException;
import com.databricks.jdbc.exception.DatabricksSQLFeatureNotSupportedException;
import com.databricks.jdbc.exception.DatabricksTransactionException;
import com.databricks.jdbc.exception.DatabricksValidationException;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import com.databricks.jdbc.model.telemetry.enums.DatabricksDriverErrorCode;
import com.databricks.jdbc.telemetry.TelemetryClientFactory;
import com.databricks.jdbc.telemetry.TelemetryHelper;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.ClientInfoStatus;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.ShardingKey;
import java.sql.Statement;
import java.sql.Struct;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;

public class DatabricksConnection
implements IDatabricksConnection,
IDatabricksConnectionInternal {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(DatabricksConnection.class);
    private final IDatabricksSession session;
    private final Set<IDatabricksStatementInternal> statementSet = ConcurrentHashMap.newKeySet();
    private SQLWarning warnings = null;
    private final IDatabricksConnectionContext connectionContext;

    public DatabricksConnection(IDatabricksConnectionContext connectionContext) throws DatabricksSQLException {
        this.connectionContext = connectionContext;
        DatabricksThreadContextHolder.setConnectionContext(connectionContext);
        this.session = new DatabricksSession(connectionContext);
    }

    @VisibleForTesting
    public DatabricksConnection(IDatabricksConnectionContext connectionContext, IDatabricksClient testDatabricksClient) throws DatabricksSQLException {
        this.connectionContext = connectionContext;
        DatabricksThreadContextHolder.setConnectionContext(connectionContext);
        this.session = new DatabricksSession(connectionContext, testDatabricksClient);
        UserAgentManager.setUserAgent(connectionContext);
        TelemetryHelper.updateTelemetryAppName(connectionContext, null);
    }

    @Override
    public void open() throws DatabricksSQLException {
        this.session.open();
    }

    @Override
    public Statement getStatement(String statementId) throws SQLException {
        return new DatabricksStatement(this, StatementId.deserialize(statementId));
    }

    @Override
    public String getConnectionId() throws SQLException {
        if (this.session.getSessionInfo() == null) {
            LOGGER.error("Session not initialized");
            throw new DatabricksValidationException("Session not initialized");
        }
        return SessionId.create(Objects.requireNonNull(this.session.getSessionInfo())).toString();
    }

    @Override
    public IDatabricksSession getSession() {
        return this.session;
    }

    @Override
    public Statement createStatement() {
        LOGGER.debug("public Statement createStatement()");
        DatabricksStatement statement = new DatabricksStatement(this);
        this.statementSet.add(statement);
        return statement;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) {
        LOGGER.debug(String.format("public PreparedStatement prepareStatement(String sql = {%s})", sql));
        DatabricksPreparedStatement statement = new DatabricksPreparedStatement(this, sql);
        this.statementSet.add(statement);
        return statement;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        LOGGER.debug(String.format("public CallableStatement prepareCall= {%s})", sql));
        throw new DatabricksSQLFeatureNotImplementedException("Callable statements are not implemented in OSS JDBC");
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        LOGGER.debug(String.format("public String nativeSQL(String sql{%s})", sql));
        throw new DatabricksSQLFeatureNotSupportedException("Databricks OSS JDBC does not support conversion to native query.");
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        LOGGER.debug("setAutoCommit({})", autoCommit);
        this.throwExceptionIfConnectionIsClosed();
        if (this.connectionContext.getIgnoreTransactions()) {
            LOGGER.warn("ignoreTransactions flag is set - setAutoCommit is no-op (deprecated behavior). Please remove this flag to enable transaction support.");
            return;
        }
        Statement statement = null;
        try {
            statement = this.createStatement();
            String sql = "SET AUTOCOMMIT = " + (autoCommit ? "TRUE" : "FALSE");
            statement.execute(sql);
            this.session.setAutoCommit(autoCommit);
        }
        catch (SQLException e) {
            LOGGER.error(e, "Error {} while setting autoCommit to {}", e.getMessage(), autoCommit);
            throw new DatabricksTransactionException(e.getMessage(), e, DatabricksDriverErrorCode.TRANSACTION_SET_AUTOCOMMIT_ERROR);
        }
        finally {
            this.closeStatementSafely(statement);
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        LOGGER.debug("getAutoCommit()");
        this.throwExceptionIfConnectionIsClosed();
        if (this.connectionContext.getFetchAutoCommitFromServer()) {
            return this.fetchAutoCommitStateFromServer();
        }
        return this.session.getAutoCommit();
    }

    private boolean fetchAutoCommitStateFromServer() throws SQLException {
        Statement statement = null;
        try {
            statement = this.createStatement();
            ResultSet rs = statement.executeQuery("SET AUTOCOMMIT");
            if (rs.next()) {
                String value = rs.getString(1);
                LOGGER.debug("Fetched autoCommit state from server: value={}. Updating session cache.", value);
                boolean autoCommitState = "true".equalsIgnoreCase(value);
                this.session.setAutoCommit(autoCommitState);
                rs.close();
                boolean bl = autoCommitState;
                return bl;
            }
            try {
                throw new DatabricksSQLException("Failed to fetch autoCommit state from server: no result returned", DatabricksDriverErrorCode.TRANSACTION_SET_AUTOCOMMIT_ERROR);
            }
            catch (SQLException e) {
                LOGGER.error(e, "Error {} while fetching autoCommit state from server", e.getMessage());
                throw new DatabricksSQLException("Failed to fetch autoCommit state from server: " + e.getMessage(), (Throwable)e, DatabricksDriverErrorCode.TRANSACTION_SET_AUTOCOMMIT_ERROR);
            }
        }
        finally {
            this.closeStatementSafely(statement);
        }
    }

    @Override
    public void commit() throws SQLException {
        LOGGER.debug("commit()");
        this.throwExceptionIfConnectionIsClosed();
        if (this.connectionContext.getIgnoreTransactions()) {
            LOGGER.warn("ignoreTransactions flag is set - commit is no-op (deprecated behavior). Please remove this flag to enable transaction support.");
            return;
        }
        Statement statement = null;
        try {
            statement = this.createStatement();
            statement.execute("COMMIT");
        }
        catch (SQLException e) {
            LOGGER.error(e, "Error {} while committing transaction", e.getMessage());
            throw new DatabricksTransactionException(e.getMessage(), e, DatabricksDriverErrorCode.TRANSACTION_COMMIT_ERROR);
        }
        finally {
            this.closeStatementSafely(statement);
        }
    }

    @Override
    public void rollback() throws SQLException {
        LOGGER.debug("rollback()");
        this.throwExceptionIfConnectionIsClosed();
        if (this.connectionContext.getIgnoreTransactions()) {
            LOGGER.warn("ignoreTransactions flag is set - rollback is no-op (deprecated behavior). Please remove this flag to enable transaction support.");
            return;
        }
        Statement statement = null;
        try {
            statement = this.createStatement();
            statement.execute("ROLLBACK");
        }
        catch (SQLException e) {
            LOGGER.error(e, "Error {} while rolling back transaction", e.getMessage());
            throw new DatabricksTransactionException(e.getMessage(), e, DatabricksDriverErrorCode.TRANSACTION_ROLLBACK_ERROR);
        }
        finally {
            this.closeStatementSafely(statement);
        }
    }

    @Override
    public void close() throws DatabricksSQLException {
        LOGGER.debug("public void close()");
        for (IDatabricksStatementInternal statement : this.statementSet) {
            statement.close(false);
            this.statementSet.remove(statement);
        }
        this.session.close();
        TelemetryClientFactory.getInstance().closeTelemetryClient(this.connectionContext);
        DatabricksClientConfiguratorManager.getInstance().removeInstance(this.connectionContext);
        DatabricksDriverFeatureFlagsContextFactory.removeInstance(this.connectionContext);
        DatabricksHttpClientFactory.getInstance().removeClient(this.connectionContext);
        DatabricksThreadContextHolder.clearAllContext();
    }

    @Override
    public boolean isClosed() throws SQLException {
        LOGGER.debug("public boolean isClosed()");
        return this.session == null || !this.session.isOpen();
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        LOGGER.debug("public DatabaseMetaData getMetaData()");
        return new DatabricksDatabaseMetaData(this);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        LOGGER.debug("public void setReadOnly(boolean readOnly)");
        this.throwExceptionIfConnectionIsClosed();
        if (readOnly) {
            throw new DatabricksSQLFeatureNotSupportedException("Databricks OSS JDBC does not support readOnly mode.");
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        LOGGER.debug("public boolean isReadOnly()");
        this.throwExceptionIfConnectionIsClosed();
        return false;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        if (!this.connectionContext.getEnableMultipleCatalogSupport()) {
            LOGGER.debug("setCatalog ignored - enableMultipleCatalogSupport is disabled");
            return;
        }
        Statement statement = this.createStatement();
        statement.execute("SET CATALOG " + catalog);
        this.session.setCatalog(catalog);
    }

    @Override
    public String getCatalog() throws SQLException {
        LOGGER.debug("public String getCatalog()");
        if (this.session.getCatalog() == null) {
            this.fetchCurrentSchemaAndCatalog();
        }
        return this.session.getCatalog();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        LOGGER.debug("public void setTransactionIsolation(int level = {})", level);
        this.throwExceptionIfConnectionIsClosed();
        if (level != 4) {
            throw new DatabricksSQLFeatureNotSupportedException("Setting of the given transaction isolation is not supported");
        }
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        LOGGER.debug("public int getTransactionIsolation()");
        this.throwExceptionIfConnectionIsClosed();
        return 4;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        LOGGER.debug("public SQLWarning getWarnings()");
        this.throwExceptionIfConnectionIsClosed();
        return this.warnings;
    }

    @Override
    public void clearWarnings() throws SQLException {
        LOGGER.debug("public void clearWarnings()");
        this.throwExceptionIfConnectionIsClosed();
        this.warnings = null;
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        if (resultSetType != 1003 || resultSetConcurrency != 1007) {
            throw new DatabricksSQLFeatureNotSupportedException("Only ResultSet.TYPE_FORWARD_ONLY and ResultSet.CONCUR_READ_ONLY are supported");
        }
        return this.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (resultSetType != 1003 || resultSetConcurrency != 1007) {
            throw new DatabricksSQLFeatureNotSupportedException("Only ResultSet.TYPE_FORWARD_ONLY and ResultSet.CONCUR_READ_ONLY are supported");
        }
        return this.prepareStatement(sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new DatabricksSQLFeatureNotImplementedException("Callable statements are not implemented in OSS JDBC");
    }

    @Override
    public Map<String, Class<?>> getTypeMap() {
        LOGGER.debug("public Map<String, Class<?>> getTypeMap()");
        return new HashMap();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        LOGGER.debug("public void setTypeMap(Map<String, Class<?>> map)");
        throw new DatabricksSQLFeatureNotSupportedException("Databricks OSS JDBC does not support setting of type map in connection");
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        if (holdability != 2) {
            throw new DatabricksSQLFeatureNotSupportedException("Databricks OSS JDBC only supports holdability of CLOSE_CURSORS_AT_COMMIT");
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        LOGGER.debug("public int getHoldability()");
        return 2;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        LOGGER.debug("public Savepoint setSavepoint()");
        if (!this.connectionContext.getIgnoreTransactions()) {
            throw new DatabricksSQLFeatureNotImplementedException("Not implemented in DatabricksConnection - setSavepoint()");
        }
        return null;
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        LOGGER.debug("public Savepoint setSavepoint(String name = {})", name);
        if (!this.connectionContext.getIgnoreTransactions()) {
            throw new DatabricksSQLFeatureNotImplementedException("Not implemented in DatabricksConnection - setSavepoint(String name)");
        }
        return null;
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        LOGGER.debug("public void rollback(Savepoint savepoint)");
        if (!this.connectionContext.getIgnoreTransactions()) {
            throw new DatabricksSQLFeatureNotImplementedException("Not implemented in DatabricksConnection - rollback(Savepoint savepoint)");
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        LOGGER.debug("public void releaseSavepoint(Savepoint savepoint)");
        if (!this.connectionContext.getIgnoreTransactions()) {
            throw new DatabricksSQLFeatureNotImplementedException("Not implemented in DatabricksConnection - releaseSavepoint(Savepoint savepoint)");
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (resultSetType != 1003 || resultSetConcurrency != 1007 || resultSetHoldability != 2) {
            throw new DatabricksSQLFeatureNotImplementedException("Databricks OSS JDBC only supports resultSetType as ResultSet.TYPE_FORWARD_ONLY, resultSetConcurrency as ResultSet.CONCUR_READ_ONLY and resultSetHoldability as ResultSet.CLOSE_CURSORS_AT_COMMIT");
        }
        return this.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (this.isClosed()) {
            throw new DatabricksSQLException("Connection is closed", DatabricksDriverErrorCode.CONNECTION_CLOSED);
        }
        if (resultSetHoldability == this.getHoldability()) {
            return this.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        throw new DatabricksSQLFeatureNotSupportedException("Databricks OSS JDBC only supports holdability of CLOSE_CURSORS_AT_COMMIT");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new DatabricksSQLFeatureNotImplementedException("Callable statements are not implemented in OSS JDBC");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        if (this.isClosed()) {
            throw new DatabricksSQLException("Connection is closed", DatabricksDriverErrorCode.CONNECTION_CLOSED);
        }
        if (autoGeneratedKeys == 2) {
            return this.prepareStatement(sql);
        }
        throw new DatabricksSQLFeatureNotSupportedException("Databricks OSS JDBC does not support auto generated keys");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new DatabricksSQLFeatureNotSupportedException("Not supported in DatabricksConnection - prepareStatement(String sql, int[] columnIndexes)");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new DatabricksSQLFeatureNotSupportedException("Not supported in DatabricksConnection - prepareStatement(String sql, String[] columnNames)");
    }

    @Override
    public Clob createClob() throws SQLException {
        LOGGER.debug("public Clob createClob()");
        throw new DatabricksSQLFeatureNotImplementedException("Not implemented in DatabricksConnection - createClob()");
    }

    @Override
    public Blob createBlob() throws SQLException {
        LOGGER.debug("public Blob createBlob()");
        throw new DatabricksSQLFeatureNotImplementedException("Not implemented in DatabricksConnection - createBlob()");
    }

    @Override
    public NClob createNClob() throws SQLException {
        LOGGER.debug("public NClob createNClob()");
        throw new DatabricksSQLFeatureNotImplementedException("Not implemented in DatabricksConnection - createNClob()");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        LOGGER.debug("public SQLXML createSQLXML()");
        throw new DatabricksSQLFeatureNotImplementedException("Not implemented in DatabricksConnection - createSQLXML()");
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        ValidationUtil.checkIfNonNegative(timeout, "timeout");
        if (this.isClosed()) {
            return false;
        }
        if (this.connectionContext.getEnableSQLValidationForIsValid()) {
            boolean bl;
            block10: {
                Statement stmt = this.createStatement();
                try {
                    stmt.setQueryTimeout(timeout);
                    stmt.execute("SELECT VERSION()");
                    bl = true;
                    if (stmt == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (stmt != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        LOGGER.debug("Validation failed for isValid(): {}", e.getMessage());
                        return false;
                    }
                }
                stmt.close();
            }
            return bl;
        }
        return true;
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        if (DatabricksJdbcConstants.ALLOWED_SESSION_CONF_TO_DEFAULT_VALUES_MAP.keySet().stream().map(String::toLowerCase).anyMatch(s2 -> s2.equalsIgnoreCase(name))) {
            HashMap<String, ClientInfoStatus> failedProperties = new HashMap<String, ClientInfoStatus>();
            this.setSessionConfig(name, value, failedProperties);
            if (!failedProperties.isEmpty()) {
                String errorMessage = DatabricksConnection.getFailedPropertiesExceptionMessage(failedProperties);
                LOGGER.error(errorMessage);
                throw new DatabricksSQLClientInfoException(errorMessage, failedProperties, DatabricksDriverErrorCode.INPUT_VALIDATION_ERROR);
            }
        } else if (DatabricksJdbcConstants.ALLOWED_CLIENT_INFO_PROPERTIES.stream().map(String::toLowerCase).anyMatch(s2 -> s2.equalsIgnoreCase(name))) {
            this.session.setClientInfoProperty(name.toLowerCase(), value);
        } else {
            String errorMessage = String.format("Setting client info for %s failed with %s", new Object[]{name, ClientInfoStatus.REASON_UNKNOWN_PROPERTY});
            LOGGER.error(errorMessage);
            throw new DatabricksSQLClientInfoException(errorMessage, Map.of(name, ClientInfoStatus.REASON_UNKNOWN_PROPERTY), DatabricksDriverErrorCode.INPUT_VALIDATION_ERROR);
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        LOGGER.debug("public void setClientInfo(Properties properties)");
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            this.setClientInfo((String)entry.getKey(), (String)entry.getValue());
        }
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        String value = this.session.getConfigValue(name);
        if (value != null) {
            return value;
        }
        return DatabricksJdbcConstants.ALLOWED_SESSION_CONF_TO_DEFAULT_VALUES_MAP.getOrDefault(name.toUpperCase(), null);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        LOGGER.debug("public Properties getClientInfo()");
        Properties properties = new Properties();
        DatabricksJdbcConstants.ALLOWED_SESSION_CONF_TO_DEFAULT_VALUES_MAP.forEach((key, value) -> properties.setProperty(key.toLowerCase(), (String)value));
        properties.putAll(this.session.getSessionConfigs());
        properties.putAll(this.session.getClientInfoProperties());
        return properties;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        LOGGER.debug("public Array createArrayOf(String typeName, Object[] elements)");
        throw new DatabricksSQLFeatureNotImplementedException("Not implemented in DatabricksConnection - createArrayOf(String typeName, Object[] elements)");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        LOGGER.debug("public Struct createStruct(String typeName, Object[] attributes)");
        throw new DatabricksSQLFeatureNotImplementedException("Not implemented in DatabricksConnection - createStruct(String typeName, Object[] attributes)");
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("USE SCHEMA " + schema);
        this.session.setSchema(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        LOGGER.debug("public String getSchema()");
        if (this.session.getSchema() == null) {
            this.fetchCurrentSchemaAndCatalog();
        }
        return this.session.getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        LOGGER.debug("public void abort(Executor executor)");
        executor.execute(() -> {
            try {
                this.close();
            }
            catch (Exception e) {
                LOGGER.error("Error closing connection resources, but marking the connection as closed.", e);
                this.session.forceClose();
            }
        });
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        LOGGER.debug("public void setNetworkTimeout(Executor executor, int milliseconds)");
        throw new DatabricksSQLFeatureNotSupportedException("Not supported in DatabricksConnection - setNetworkTimeout(Executor executor, int milliseconds)");
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        LOGGER.debug("public int getNetworkTimeout()");
        throw new DatabricksSQLFeatureNotSupportedException("Not supported in DatabricksConnection - getNetworkTimeout()");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        LOGGER.debug("public <T> T unwrap(Class<T> iface)");
        if (iface.isInstance(this)) {
            return (T)this;
        }
        String errorMessage = String.format("Class {%s} cannot be wrapped from {%s}", this.getClass().getName(), iface.getName());
        LOGGER.error(errorMessage);
        throw new DatabricksValidationException(errorMessage);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        LOGGER.debug("public boolean isWrapperFor(Class<?> iface)");
        return iface.isInstance(this);
    }

    @Override
    public void closeStatement(IDatabricksStatement statement) {
        LOGGER.debug("public void closeStatement(IDatabricksStatement statement)");
        this.statementSet.remove(statement);
    }

    @Override
    public void beginRequest() {
        LOGGER.debug("public void beginRequest()");
        LOGGER.warn("public void beginRequest() is a no-op method");
    }

    @Override
    public void endRequest() {
        LOGGER.debug("public void endRequest()");
        LOGGER.warn("public void endRequest() is a no-op method");
    }

    @Override
    public boolean setShardingKeyIfValid(ShardingKey shardingKey, ShardingKey superShardingKey, int timeout) throws DatabricksSQLFeatureNotImplementedException {
        LOGGER.debug("public boolean setShardingKeyIfValid(ShardingKey shardingKey = {},ShardingKey superShardingKey = {}, int timeout = {})", shardingKey, superShardingKey, timeout);
        throw new DatabricksSQLFeatureNotImplementedException("Not implemented in DatabricksConnection - setShardingKeyIfValid(ShardingKey shardingKey, ShardingKey superShardingKey, int timeout)");
    }

    @Override
    public boolean setShardingKeyIfValid(ShardingKey shardingKey, int timeout) throws DatabricksSQLFeatureNotImplementedException {
        LOGGER.debug("public boolean setShardingKeyIfValid(ShardingKey shardingKey = {}, int timeout = {})", shardingKey, timeout);
        throw new DatabricksSQLFeatureNotImplementedException("Not implemented in DatabricksConnection - setShardingKeyIfValid(ShardingKey shardingKey, int timeout)");
    }

    @Override
    public void setShardingKey(ShardingKey shardingKey, ShardingKey superShardingKey) throws DatabricksSQLFeatureNotImplementedException {
        LOGGER.debug("public void setShardingKey(ShardingKey shardingKey = {}, ShardingKey superShardingKey = {})", shardingKey, superShardingKey);
        throw new DatabricksSQLFeatureNotImplementedException("Not implemented in DatabricksConnection - setShardingKey(ShardingKey shardingKey, ShardingKey superShardingKey)");
    }

    @Override
    public void setShardingKey(ShardingKey shardingKey) throws DatabricksSQLFeatureNotImplementedException {
        LOGGER.debug("public void setShardingKey(ShardingKey shardingKey = {})", shardingKey);
        throw new DatabricksSQLFeatureNotImplementedException("Not implemented in DatabricksConnection - setShardingKey(ShardingKey shardingKey)");
    }

    @Override
    public Connection getConnection() {
        return this;
    }

    @Override
    public IDatabricksConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    private static String getFailedPropertiesExceptionMessage(Map<String, ClientInfoStatus> failedProperties) {
        return failedProperties.entrySet().stream().map(e -> String.format("Setting config %s failed with %s", e.getKey(), e.getValue())).collect(Collectors.joining("\n"));
    }

    private static ClientInfoStatus determineClientInfoStatus(String key, String value, Throwable e) {
        String invalidConfigMessage = String.format("Configuration %s is not available", key);
        String invalidValueMessage = String.format("Unsupported configuration %s=%s", key, value);
        String errorMessage = e.getCause().getMessage();
        if (errorMessage.contains(invalidConfigMessage)) {
            return ClientInfoStatus.REASON_UNKNOWN_PROPERTY;
        }
        if (errorMessage.contains(invalidValueMessage)) {
            return ClientInfoStatus.REASON_VALUE_INVALID;
        }
        return ClientInfoStatus.REASON_UNKNOWN;
    }

    private void setSessionConfig(String key, String value, Map<String, ClientInfoStatus> failedProperties) {
        try {
            this.createStatement().execute(String.format("SET %s = %s", key, value));
            this.session.setSessionConfig(key.toLowerCase(), value);
        }
        catch (SQLException e) {
            ClientInfoStatus status = DatabricksConnection.determineClientInfoStatus(key, value, e);
            failedProperties.put(key, status);
        }
    }

    private void throwExceptionIfConnectionIsClosed() throws SQLException {
        if (this.isClosed()) {
            throw new DatabricksSQLException("Connection closed!", DatabricksDriverErrorCode.CONNECTION_CLOSED);
        }
    }

    private void fetchCurrentSchemaAndCatalog() throws DatabricksSQLException {
        try {
            DatabricksStatement statement = (DatabricksStatement)this.createStatement();
            ResultSet rs = statement.executeQuery("SELECT CURRENT_CATALOG(), CURRENT_SCHEMA()");
            if (rs.next()) {
                this.session.setCatalog(rs.getString(1));
                this.session.setSchema(rs.getString(2));
            }
        }
        catch (SQLException e) {
            String errorMessage = String.format("Error fetching current schema and catalog %s", e.getMessage());
            LOGGER.error(e, errorMessage);
            throw new DatabricksSQLException(errorMessage, DatabricksDriverErrorCode.CATALOG_OR_SCHEMA_FETCH_ERROR);
        }
    }

    private void closeStatementSafely(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                LOGGER.error(e, "Error closing statement: {}", e.getMessage());
            }
        }
    }
}

