/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.api.impl;

import com.databricks.internal.google.common.collect.ImmutableList;
import com.databricks.jdbc.api.impl.CaseInsensitiveImmutableMap;
import com.databricks.jdbc.api.impl.ImmutableDatabricksColumn;
import com.databricks.jdbc.api.internal.IDatabricksConnectionContext;
import com.databricks.jdbc.common.AccessType;
import com.databricks.jdbc.common.MetadataResultConstants;
import com.databricks.jdbc.common.Nullable;
import com.databricks.jdbc.common.util.DatabricksThriftUtil;
import com.databricks.jdbc.common.util.DatabricksTypeUtil;
import com.databricks.jdbc.common.util.WrapperUtil;
import com.databricks.jdbc.dbclient.impl.common.MetadataResultSetBuilder;
import com.databricks.jdbc.dbclient.impl.common.StatementId;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import com.databricks.jdbc.model.client.thrift.generated.TColumnDesc;
import com.databricks.jdbc.model.client.thrift.generated.TGetResultSetMetadataResp;
import com.databricks.jdbc.model.client.thrift.generated.TSparkRowSetType;
import com.databricks.jdbc.model.core.ColumnInfo;
import com.databricks.jdbc.model.core.ColumnInfoTypeName;
import com.databricks.jdbc.model.core.ColumnMetadata;
import com.databricks.jdbc.model.core.ResultManifest;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class DatabricksResultSetMetaData
implements ResultSetMetaData {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(DatabricksResultSetMetaData.class);
    private final StatementId statementId;
    private IDatabricksConnectionContext ctx;
    private final ImmutableList<ImmutableDatabricksColumn> columns;
    private final CaseInsensitiveImmutableMap<Integer> columnNameIndex;
    private final long totalRows;
    private Long chunkCount;
    private final boolean isCloudFetchUsed;

    public DatabricksResultSetMetaData(StatementId statementId, ResultManifest resultManifest, boolean usesExternalLinks, IDatabricksConnectionContext ctx) {
        this.ctx = ctx;
        this.statementId = statementId;
        HashMap<String, Integer> columnNameToIndexMap = new HashMap<String, Integer>();
        ImmutableList.Builder columnsBuilder = ImmutableList.builder();
        MetadataResultSetBuilder metadataResultSetBuilder = new MetadataResultSetBuilder(ctx);
        int currIndex = 0;
        if (resultManifest.getIsVolumeOperation() != null && resultManifest.getIsVolumeOperation().booleanValue()) {
            ImmutableDatabricksColumn.Builder columnBuilder = this.getColumnBuilder();
            columnBuilder.columnName("operation_status").columnType(12).columnTypeText(ColumnInfoTypeName.STRING.name()).typePrecision(0).columnTypeClassName(DatabricksTypeUtil.getColumnTypeClassName(ColumnInfoTypeName.STRING)).displaySize(DatabricksTypeUtil.getDisplaySize(ColumnInfoTypeName.STRING, 0, 0)).isSearchable(true).schemaName(null).tableName(null).isSigned(DatabricksTypeUtil.isSigned(ColumnInfoTypeName.STRING));
            columnsBuilder.add(columnBuilder.build());
            columnNameToIndexMap.putIfAbsent("operation_status", ++currIndex);
        } else if (resultManifest.getSchema().getColumnCount() > 0L) {
            for (ColumnInfo columnInfo : resultManifest.getSchema().getColumns()) {
                ColumnInfoTypeName columnTypeName = columnInfo.getTypeName();
                if (columnInfo.getTypeText().equalsIgnoreCase("TIMESTAMP_NTZ")) {
                    columnTypeName = ColumnInfoTypeName.TIMESTAMP;
                    columnInfo.setTypeText("TIMESTAMP");
                }
                String typeText = columnInfo.getTypeText();
                if (!ctx.isGeoSpatialSupportEnabled() && this.isGeospatialType(columnTypeName)) {
                    LOGGER.debug("Geospatial support is disabled, converting {} to STRING in metadata", new Object[]{columnTypeName});
                    columnTypeName = ColumnInfoTypeName.STRING;
                    typeText = "STRING";
                }
                int columnType = DatabricksTypeUtil.getColumnType(columnTypeName);
                int[] precisionAndScale = this.getPrecisionAndScale(columnInfo, columnType);
                int precision = precisionAndScale[0];
                int scale = precisionAndScale[1];
                ImmutableDatabricksColumn.Builder columnBuilder = this.getColumnBuilder();
                columnBuilder.columnName(columnInfo.getName()).columnTypeClassName(DatabricksTypeUtil.getColumnTypeClassName(columnTypeName)).columnType(columnType).columnTypeText(metadataResultSetBuilder.stripTypeName(typeText)).typePrecision(precision).typeScale(scale).displaySize(DatabricksTypeUtil.getDisplaySize(columnTypeName, precision, scale)).isSearchable(true).schemaName(null).tableName(null).isSigned(DatabricksTypeUtil.isSigned(columnTypeName));
                columnsBuilder.add(columnBuilder.build());
                columnNameToIndexMap.putIfAbsent(columnInfo.getName(), ++currIndex);
            }
        }
        this.columns = columnsBuilder.build();
        this.columnNameIndex = CaseInsensitiveImmutableMap.copyOf(columnNameToIndexMap);
        this.totalRows = resultManifest.getTotalRowCount();
        this.chunkCount = resultManifest.getTotalChunkCount();
        this.isCloudFetchUsed = usesExternalLinks;
    }

    public DatabricksResultSetMetaData(StatementId statementId, TGetResultSetMetadataResp resultManifest, long rows, long chunkCount, List<String> arrowMetadata, IDatabricksConnectionContext ctx) {
        this.ctx = ctx;
        this.statementId = statementId;
        HashMap<String, Integer> columnNameToIndexMap = new HashMap<String, Integer>();
        ImmutableList.Builder columnsBuilder = ImmutableList.builder();
        LOGGER.debug(String.format("Result manifest for statement {%s} has schema: {%s}", statementId, resultManifest.getSchema()));
        int currIndex = 0;
        if (resultManifest.isSetIsStagingOperation() && resultManifest.isIsStagingOperation()) {
            ImmutableDatabricksColumn.Builder columnBuilder = this.getColumnBuilder();
            columnBuilder.columnName("operation_status").columnType(12).columnTypeText(ColumnInfoTypeName.STRING.name()).typePrecision(0).columnTypeClassName(DatabricksTypeUtil.getColumnTypeClassName(ColumnInfoTypeName.STRING)).displaySize(DatabricksTypeUtil.getDisplaySize(ColumnInfoTypeName.STRING, 0, 0)).isSearchable(true).schemaName(null).tableName(null).isSigned(DatabricksTypeUtil.isSigned(ColumnInfoTypeName.STRING));
            columnsBuilder.add(columnBuilder.build());
            columnNameToIndexMap.putIfAbsent("operation_status", ++currIndex);
        } else if (resultManifest.getSchema() != null && resultManifest.getSchema().getColumnsSize() > 0) {
            for (int columnIndex = 0; columnIndex < resultManifest.getSchema().getColumnsSize(); ++columnIndex) {
                TColumnDesc columnDesc = resultManifest.getSchema().getColumns().get(columnIndex);
                ColumnInfo columnInfo = DatabricksThriftUtil.getColumnInfoFromTColumnDesc(columnDesc);
                int[] precisionAndScale = this.getPrecisionAndScale(columnInfo);
                int precision = precisionAndScale[0];
                int scale = precisionAndScale[1];
                ImmutableDatabricksColumn.Builder columnBuilder = this.getColumnBuilder();
                String columnTypeText = arrowMetadata != null && columnIndex < arrowMetadata.size() && arrowMetadata.get(columnIndex) != null ? arrowMetadata.get(columnIndex) : DatabricksThriftUtil.getTypeTextFromTypeDesc(columnDesc.getTypeDesc());
                columnBuilder.columnName(columnInfo.getName()).columnTypeClassName(DatabricksTypeUtil.getColumnTypeClassName(columnInfo.getTypeName())).columnType(DatabricksTypeUtil.getColumnType(columnInfo.getTypeName())).columnTypeText(columnTypeText).typePrecision(precision).typeScale(scale).displaySize(DatabricksTypeUtil.getDisplaySize(columnInfo.getTypeName(), precision, scale)).isSearchable(true).schemaName(null).tableName(null).isSigned(DatabricksTypeUtil.isSigned(columnInfo.getTypeName()));
                if (this.isVariantColumn(arrowMetadata, columnIndex)) {
                    columnBuilder.columnTypeClassName("java.lang.String").columnType(1111).columnTypeText("VARIANT");
                } else if (this.isGeometryColumn(arrowMetadata, columnIndex) && ctx.isGeoSpatialSupportEnabled()) {
                    columnBuilder.columnTypeClassName("com.databricks.jdbc.api.IGeometry").columnType(1111).columnTypeText("GEOMETRY");
                } else if (this.isGeographyColumn(arrowMetadata, columnIndex) && ctx.isGeoSpatialSupportEnabled()) {
                    columnBuilder.columnTypeClassName("com.databricks.jdbc.api.IGeography").columnType(1111).columnTypeText("GEOGRAPHY");
                } else if ((this.isGeometryColumn(arrowMetadata, columnIndex) || this.isGeographyColumn(arrowMetadata, columnIndex)) && !ctx.isGeoSpatialSupportEnabled()) {
                    LOGGER.debug("Geospatial support is disabled, converting column {} to STRING in Thrift metadata", columnInfo.getName());
                    columnBuilder.columnTypeClassName("java.lang.String").columnType(12).columnTypeText("STRING");
                }
                columnsBuilder.add(columnBuilder.build());
                columnNameToIndexMap.putIfAbsent(columnInfo.getName(), ++currIndex);
            }
        }
        this.columns = columnsBuilder.build();
        this.columnNameIndex = CaseInsensitiveImmutableMap.copyOf(columnNameToIndexMap);
        this.totalRows = rows;
        this.chunkCount = chunkCount;
        this.isCloudFetchUsed = this.getIsCloudFetchFromManifest(resultManifest);
    }

    public DatabricksResultSetMetaData(StatementId statementId, List<ColumnMetadata> columnMetadataList, long totalRows) {
        this.statementId = statementId;
        HashMap<String, Integer> columnNameToIndexMap = new HashMap<String, Integer>();
        ImmutableList.Builder columnsBuilder = ImmutableList.builder();
        for (int i = 0; i < columnMetadataList.size(); ++i) {
            ColumnMetadata metadata = columnMetadataList.get(i);
            ColumnInfoTypeName columnTypeName = ColumnInfoTypeName.valueOf(DatabricksTypeUtil.getDatabricksTypeFromSQLType(metadata.getTypeInt()));
            ImmutableDatabricksColumn.Builder columnBuilder = this.getColumnBuilder();
            columnBuilder.columnName(metadata.getName()).columnType(metadata.getTypeInt()).columnTypeText(metadata.getTypeText()).typePrecision(metadata.getPrecision()).columnTypeClassName(DatabricksTypeUtil.getColumnTypeClassName(columnTypeName)).typeScale(metadata.getScale()).nullable(DatabricksTypeUtil.getNullableFromValue(metadata.getNullable())).displaySize(DatabricksTypeUtil.getDisplaySize(metadata.getTypeInt(), metadata.getPrecision())).isSigned(DatabricksTypeUtil.isSigned(columnTypeName));
            if (this.isLargeColumn(metadata.getName())) {
                columnBuilder.typePrecision(254);
                columnBuilder.displaySize(254);
            }
            columnsBuilder.add(columnBuilder.build());
            columnNameToIndexMap.putIfAbsent(metadata.getName(), i + 1);
        }
        this.columns = columnsBuilder.build();
        this.columnNameIndex = CaseInsensitiveImmutableMap.copyOf(columnNameToIndexMap);
        this.totalRows = totalRows;
        this.isCloudFetchUsed = false;
    }

    public DatabricksResultSetMetaData(StatementId statementId, List<String> columnNames, List<String> columnTypeText, List<Integer> columnTypes, List<Integer> columnTypePrecisions, List<Nullable> columnNullables, long totalRows) {
        this.statementId = statementId;
        HashMap<String, Integer> columnNameToIndexMap = new HashMap<String, Integer>();
        ImmutableList.Builder columnsBuilder = ImmutableList.builder();
        for (int i = 0; i < columnNames.size(); ++i) {
            ColumnInfoTypeName columnTypeName = ColumnInfoTypeName.valueOf(DatabricksTypeUtil.getDatabricksTypeFromSQLType(columnTypes.get(i)));
            ImmutableDatabricksColumn.Builder columnBuilder = this.getColumnBuilder();
            columnBuilder.columnName(columnNames.get(i)).columnType(columnTypes.get(i)).columnTypeText(columnTypeText.get(i)).typePrecision(columnTypePrecisions.get(i)).columnTypeClassName(DatabricksTypeUtil.getColumnTypeClassName(columnTypeName)).displaySize(DatabricksTypeUtil.getDisplaySize(columnTypes.get(i), columnTypePrecisions.get(i))).nullable(columnNullables.get(i)).isSigned(DatabricksTypeUtil.isSigned(columnTypeName));
            if (this.isLargeColumn(columnNames.get(i))) {
                columnBuilder.typePrecision(254);
                columnBuilder.displaySize(254);
            }
            columnsBuilder.add(columnBuilder.build());
            columnNameToIndexMap.putIfAbsent(columnNames.get(i), i + 1);
        }
        this.columns = columnsBuilder.build();
        this.columnNameIndex = CaseInsensitiveImmutableMap.copyOf(columnNameToIndexMap);
        this.totalRows = totalRows;
        this.isCloudFetchUsed = false;
    }

    public DatabricksResultSetMetaData(StatementId statementId, List<String> columnNames, List<String> columnTypeText, int[] columnTypes, int[] columnTypePrecisions, int[] isNullables, long totalRows) {
        this.statementId = statementId;
        HashMap<String, Integer> columnNameToIndexMap = new HashMap<String, Integer>();
        ImmutableList.Builder columnsBuilder = ImmutableList.builder();
        for (int i = 0; i < columnNames.size(); ++i) {
            ColumnInfoTypeName columnTypeName = ColumnInfoTypeName.valueOf(DatabricksTypeUtil.getDatabricksTypeFromSQLType(columnTypes[i]));
            ImmutableDatabricksColumn.Builder columnBuilder = this.getColumnBuilder();
            columnBuilder.columnName(columnNames.get(i)).columnType(columnTypes[i]).columnTypeText(columnTypeText.get(i)).typePrecision(columnTypePrecisions[i]).nullable(DatabricksTypeUtil.getNullableFromValue(isNullables[i])).columnTypeClassName(DatabricksTypeUtil.getColumnTypeClassName(columnTypeName)).displaySize(DatabricksTypeUtil.getDisplaySize(columnTypes[i], columnTypePrecisions[i])).isSigned(DatabricksTypeUtil.isSigned(columnTypeName));
            if (columnNames.get(i).equals(MetadataResultConstants.REMARKS_COLUMN.getColumnName())) {
                columnBuilder.displaySize(254);
            }
            columnsBuilder.add(columnBuilder.build());
            columnNameToIndexMap.putIfAbsent(columnNames.get(i), i + 1);
        }
        this.columns = columnsBuilder.build();
        this.columnNameIndex = CaseInsensitiveImmutableMap.copyOf(columnNameToIndexMap);
        this.totalRows = totalRows;
        this.isCloudFetchUsed = false;
    }

    public DatabricksResultSetMetaData(StatementId statementId, List<String> columnNames, List<String> columnDataTypes, IDatabricksConnectionContext ctx) {
        this.ctx = ctx;
        ImmutableList.Builder columnsBuilder = ImmutableList.builder();
        HashMap<String, Integer> columnNameToIndexMap = new HashMap<String, Integer>();
        MetadataResultSetBuilder metadataResultSetBuilder = new MetadataResultSetBuilder(ctx);
        columnDataTypes = columnDataTypes.stream().map(String::toUpperCase).collect(Collectors.toCollection(ArrayList::new));
        for (int i = 0; i < columnNames.size(); ++i) {
            ColumnInfoTypeName columnTypeName;
            String columnName = columnNames.get(i);
            String columnTypeText = (String)columnDataTypes.get(i);
            if (columnTypeText.equalsIgnoreCase("TIMESTAMP_NTZ")) {
                columnTypeName = ColumnInfoTypeName.TIMESTAMP;
                columnTypeText = "TIMESTAMP";
            } else if (columnTypeText.equalsIgnoreCase("VARIANT")) {
                columnTypeName = ColumnInfoTypeName.STRING;
                columnTypeText = "VARIANT";
            } else {
                columnTypeName = ColumnInfoTypeName.valueOf(metadataResultSetBuilder.stripBaseTypeName(columnTypeText));
            }
            int columnType = DatabricksTypeUtil.getColumnType(columnTypeName);
            int[] precisionAndScale = this.getPrecisionAndScale(columnTypeText, columnType);
            int precision = precisionAndScale[0];
            int scale = precisionAndScale[1];
            ImmutableDatabricksColumn.Builder columnBuilder = this.getColumnBuilder();
            columnBuilder.columnName(columnName).columnTypeClassName(DatabricksTypeUtil.getColumnTypeClassName(columnTypeName)).columnType(columnType).columnTypeText(metadataResultSetBuilder.stripBaseTypeName(columnTypeText)).typePrecision(precision).typeScale(scale).displaySize(DatabricksTypeUtil.getDisplaySize(columnTypeName, precision, scale)).isSearchable(true).schemaName(null).tableName(null).isSigned(DatabricksTypeUtil.isSigned(columnTypeName));
            columnsBuilder.add(columnBuilder.build());
            columnNameToIndexMap.putIfAbsent(columnName, i + 1);
        }
        this.statementId = statementId;
        this.isCloudFetchUsed = false;
        this.totalRows = -1L;
        this.columns = columnsBuilder.build();
        this.columnNameIndex = CaseInsensitiveImmutableMap.copyOf(columnNameToIndexMap);
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.columns.size();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return ((ImmutableDatabricksColumn)this.columns.get(this.getEffectiveIndex(column))).isAutoIncrement();
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return ((ImmutableDatabricksColumn)this.columns.get(this.getEffectiveIndex(column))).isCaseSensitive();
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return ((ImmutableDatabricksColumn)this.columns.get(this.getEffectiveIndex(column))).isSearchable();
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return ((ImmutableDatabricksColumn)this.columns.get(this.getEffectiveIndex(column))).isCurrency();
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return ((ImmutableDatabricksColumn)this.columns.get(this.getEffectiveIndex(column))).nullable().getValue();
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return ((ImmutableDatabricksColumn)this.columns.get(this.getEffectiveIndex(column))).isSigned();
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return ((ImmutableDatabricksColumn)this.columns.get(this.getEffectiveIndex(column))).displaySize();
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return ((ImmutableDatabricksColumn)this.columns.get(this.getEffectiveIndex(column))).columnName();
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return ((ImmutableDatabricksColumn)this.columns.get(this.getEffectiveIndex(column))).columnName();
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return ((ImmutableDatabricksColumn)this.columns.get(this.getEffectiveIndex(column))).schemaName();
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return ((ImmutableDatabricksColumn)this.columns.get(this.getEffectiveIndex(column))).typePrecision();
    }

    @Override
    public int getScale(int column) throws SQLException {
        return ((ImmutableDatabricksColumn)this.columns.get(this.getEffectiveIndex(column))).typeScale();
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return ((ImmutableDatabricksColumn)this.columns.get(this.getEffectiveIndex(column))).tableName();
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return ((ImmutableDatabricksColumn)this.columns.get(this.getEffectiveIndex(column))).catalogName();
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        return ((ImmutableDatabricksColumn)this.columns.get(this.getEffectiveIndex(column))).columnType();
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return ((ImmutableDatabricksColumn)this.columns.get(this.getEffectiveIndex(column))).columnTypeText();
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        AccessType columnAccessType = ((ImmutableDatabricksColumn)this.columns.get(this.getEffectiveIndex(column))).accessType();
        return columnAccessType.equals((Object)AccessType.READ_ONLY) || columnAccessType.equals((Object)AccessType.UNKNOWN);
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return ((ImmutableDatabricksColumn)this.columns.get(this.getEffectiveIndex(column))).accessType().equals((Object)AccessType.WRITE);
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return ((ImmutableDatabricksColumn)this.columns.get(this.getEffectiveIndex(column))).isDefinitelyWritable();
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        return ((ImmutableDatabricksColumn)this.columns.get(this.getEffectiveIndex(column))).columnTypeClassName();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return WrapperUtil.unwrap(iface, this);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return WrapperUtil.isWrapperFor(iface, this);
    }

    private int getEffectiveIndex(int columnIndex) {
        if (columnIndex > 0 && columnIndex <= this.columns.size()) {
            return columnIndex - 1;
        }
        throw new IllegalStateException("Invalid column index: " + columnIndex);
    }

    public int getColumnNameIndex(String columnName) {
        return this.columnNameIndex.getOrDefault(columnName, -1);
    }

    public long getTotalRows() {
        return this.totalRows;
    }

    public boolean getIsCloudFetchUsed() {
        return this.isCloudFetchUsed;
    }

    private boolean getIsCloudFetchFromManifest(TGetResultSetMetadataResp resultManifest) {
        return resultManifest.getResultFormat() == TSparkRowSetType.URL_BASED_SET;
    }

    public Long getChunkCount() {
        return this.chunkCount;
    }

    public int[] getPrecisionAndScale(String columnTypeText, int columnType) {
        int[] result = DatabricksTypeUtil.getBasePrecisionAndScale(columnType, this.ctx);
        Pattern pattern = Pattern.compile("decimal\\((\\d+),\\s*(\\d+)\\)", 2);
        Matcher matcher = pattern.matcher(columnTypeText);
        if (matcher.matches()) {
            result[0] = Integer.parseInt(matcher.group(1));
            result[1] = Integer.parseInt(matcher.group(2));
        }
        return result;
    }

    public int[] getPrecisionAndScale(ColumnInfo columnInfo, int columnType) {
        int[] result = DatabricksTypeUtil.getBasePrecisionAndScale(columnType, this.ctx);
        if (columnInfo.getTypePrecision() != null) {
            result[0] = Math.toIntExact(columnInfo.getTypePrecision());
            result[1] = Math.toIntExact(columnInfo.getTypeScale());
        }
        return result;
    }

    public int[] getPrecisionAndScale(ColumnInfo columnInfo) {
        return this.getPrecisionAndScale(columnInfo, DatabricksTypeUtil.getColumnType(columnInfo.getTypeName()));
    }

    private boolean isLargeColumn(String columnName) {
        return MetadataResultConstants.LARGE_DISPLAY_COLUMNS.stream().anyMatch(column -> column.getColumnName().equals(columnName));
    }

    private boolean isVariantColumn(List<String> arrowMetadata, int i) {
        return arrowMetadata != null && arrowMetadata.size() > i && arrowMetadata.get(i) != null && arrowMetadata.get(i).equalsIgnoreCase("VARIANT");
    }

    private boolean isGeometryColumn(List<String> arrowMetadata, int index) {
        return arrowMetadata != null && arrowMetadata.size() > index && arrowMetadata.get(index) != null && arrowMetadata.get(index).contains("GEOMETRY");
    }

    private boolean isGeographyColumn(List<String> arrowMetadata, int index) {
        return arrowMetadata != null && arrowMetadata.size() > index && arrowMetadata.get(index) != null && arrowMetadata.get(index).contains("GEOGRAPHY");
    }

    private boolean isGeospatialType(ColumnInfoTypeName type) {
        return type == ColumnInfoTypeName.GEOMETRY || type == ColumnInfoTypeName.GEOGRAPHY;
    }

    private ImmutableDatabricksColumn.Builder getColumnBuilder() {
        return ImmutableDatabricksColumn.builder().isAutoIncrement(false).isSearchable(false).nullable(Nullable.NULLABLE).accessType(AccessType.READ_ONLY).isDefinitelyWritable(false).schemaName("").tableName("").catalogName("").isCurrency(false).typeScale(0).isCaseSensitive(false);
    }
}

