/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.api.impl.converters;

import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import java.time.Duration;
import java.time.Period;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IntervalConverter {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(IntervalConverter.class);
    private static final long NANOS_PER_SECOND = 1000000000L;
    private static final long NANOS_PER_MINUTE = 60000000000L;
    private static final long NANOS_PER_HOUR = 3600000000000L;
    private static final long NANOS_PER_DAY = 86400000000000L;
    private static final Pattern INTERVAL_PATTERN = Pattern.compile("INTERVAL\\s+(\\w+)(?:\\s+TO\\s+(\\w+))?", 2);
    private final boolean isYearMonth;

    public IntervalConverter(String arrowMetadata) {
        Matcher m4 = INTERVAL_PATTERN.matcher(arrowMetadata.trim());
        if (!m4.matches()) {
            throw new IllegalArgumentException("Invalid interval metadata: " + arrowMetadata);
        }
        Field start = Field.valueOf(m4.group(1).toUpperCase());
        this.isYearMonth = start.equals((Object)Field.YEAR) || start.equals((Object)Field.MONTH);
    }

    public String toLiteral(Object obj) {
        String body;
        if (this.isYearMonth) {
            if (!(obj instanceof Period)) {
                throw new IllegalArgumentException("Expected Period, got " + String.valueOf(obj.getClass()));
            }
            body = this.formatYearMonth((Period)obj);
        } else {
            if (!(obj instanceof Duration)) {
                throw new IllegalArgumentException("Expected Duration, got " + String.valueOf(obj.getClass()));
            }
            body = this.formatFullDayTime((Duration)obj);
        }
        return body;
    }

    private String formatYearMonth(Period p) {
        long totalMonths = (long)p.getYears() * 12L + (long)p.getMonths();
        boolean neg = totalMonths < 0L;
        long absMonths = Math.abs(totalMonths);
        long years = absMonths / 12L;
        long months = absMonths % 12L;
        String body = years + "-" + months;
        return (neg ? "-" : "") + body;
    }

    private String formatFullDayTime(Duration d) {
        boolean neg;
        long nanos = d.toNanos();
        if (nanos == Long.MIN_VALUE) {
            ++nanos;
        }
        boolean bl = neg = nanos < 0L;
        if (neg) {
            nanos = -nanos;
        }
        if (nanos == Long.MAX_VALUE) {
            LOGGER.warn("Duration value at Long.MAX_VALUE detected - interval representation may be incorrect due to overflow");
        }
        long days = nanos / 86400000000000L;
        long hours = (nanos %= 86400000000000L) / 3600000000000L;
        long minutes = (nanos %= 3600000000000L) / 60000000000L;
        long seconds = (nanos %= 60000000000L) / 1000000000L;
        long frac = nanos % 1000000000L;
        return String.format("%s%d %02d:%02d:%02d.%09d", neg ? "-" : "", days, hours, minutes, seconds, frac);
    }

    public static enum Field {
        YEAR,
        MONTH,
        DAY,
        HOUR,
        MINUTE,
        SECOND;

    }
}

