/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.api.impl.converters;

import com.databricks.jdbc.api.impl.converters.ObjectConverter;
import com.databricks.jdbc.exception.DatabricksSQLException;
import com.databricks.jdbc.exception.DatabricksValidationException;
import com.databricks.jdbc.model.telemetry.enums.DatabricksDriverErrorCode;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;

public class LongConverter
implements ObjectConverter {
    @Override
    public long toLong(Object object) throws DatabricksSQLException {
        if (object instanceof String) {
            return Long.parseLong((String)object);
        }
        if (object instanceof Number) {
            return ((Number)object).longValue();
        }
        throw new DatabricksSQLException("Unsupported type for LongObjectConverter: " + String.valueOf(object.getClass()), DatabricksDriverErrorCode.UNSUPPORTED_OPERATION);
    }

    @Override
    public byte toByte(Object object) throws DatabricksSQLException {
        long value = this.toLong(object);
        if (value >= -128L && value <= 127L) {
            return (byte)value;
        }
        throw new DatabricksValidationException("Invalid conversion: Long value out of byte range");
    }

    @Override
    public short toShort(Object object) throws DatabricksSQLException {
        long value = this.toLong(object);
        if (value >= -32768L && value <= 32767L) {
            return (short)value;
        }
        throw new DatabricksValidationException("Invalid conversion: Long value out of short range");
    }

    @Override
    public int toInt(Object object) throws DatabricksSQLException {
        long value = this.toLong(object);
        if (value >= Integer.MIN_VALUE && value <= Integer.MAX_VALUE) {
            return (int)value;
        }
        throw new DatabricksValidationException("Invalid conversion: Long value out of int range");
    }

    @Override
    public float toFloat(Object object) throws DatabricksSQLException {
        return this.toLong(object);
    }

    @Override
    public double toDouble(Object object) throws DatabricksSQLException {
        return this.toLong(object);
    }

    @Override
    public BigDecimal toBigDecimal(Object object) throws DatabricksSQLException {
        return BigDecimal.valueOf(this.toLong(object));
    }

    @Override
    public BigInteger toBigInteger(Object object) throws DatabricksSQLException {
        return BigInteger.valueOf(this.toLong(object));
    }

    @Override
    public boolean toBoolean(Object object) throws DatabricksSQLException {
        return this.toLong(object) != 0L;
    }

    @Override
    public byte[] toByteArray(Object object) throws DatabricksSQLException {
        return ByteBuffer.allocate(8).putLong(this.toLong(object)).array();
    }

    @Override
    public String toString(Object object) throws DatabricksSQLException {
        return String.valueOf(this.toLong(object));
    }

    @Override
    public Timestamp toTimestamp(Object object) throws DatabricksSQLException {
        return this.toTimestamp(object, 3);
    }

    @Override
    public Timestamp toTimestamp(Object object, int scale) throws DatabricksSQLException {
        if (scale > 9) {
            throw new DatabricksSQLException("Unsupported scale", DatabricksDriverErrorCode.UNSUPPORTED_OPERATION);
        }
        long nanoseconds = this.toLong(object) * POWERS_OF_TEN[9 - scale];
        Time time = new Time(nanoseconds / POWERS_OF_TEN[6]);
        return new Timestamp(time.getTime());
    }

    @Override
    public Date toDate(Object object) throws DatabricksSQLException {
        LocalDate localDate = LocalDate.ofEpochDay(this.toLong(object));
        return Date.valueOf(localDate);
    }
}

