/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.auth;

import com.databricks.internal.google.common.annotations.VisibleForTesting;
import com.databricks.internal.sdk.core.CredentialsProvider;
import com.databricks.internal.sdk.core.DatabricksConfig;
import com.databricks.internal.sdk.core.HeaderFactory;
import com.databricks.internal.sdk.core.oauth.Token;
import com.databricks.jdbc.api.internal.IDatabricksConnectionContext;
import com.databricks.jdbc.auth.JwtPrivateKeyClientCredentials;
import com.databricks.jdbc.common.util.DatabricksAuthUtil;
import com.databricks.jdbc.dbclient.IDatabricksHttpClient;
import com.databricks.jdbc.dbclient.impl.http.DatabricksHttpClientFactory;
import java.util.Collections;
import java.util.HashMap;

public class PrivateKeyClientCredentialProvider
implements CredentialsProvider {
    IDatabricksConnectionContext connectionContext;
    String tokenEndpoint;
    IDatabricksHttpClient httpClient;

    public PrivateKeyClientCredentialProvider(IDatabricksConnectionContext connectionContext, DatabricksConfig databricksConfig) {
        this.connectionContext = connectionContext;
        this.httpClient = DatabricksHttpClientFactory.getInstance().getClient(connectionContext);
        this.tokenEndpoint = DatabricksAuthUtil.getTokenEndpoint(databricksConfig, connectionContext);
    }

    @Override
    public String authType() {
        return "custom-oauth-m2m";
    }

    @VisibleForTesting
    JwtPrivateKeyClientCredentials getClientCredentialObject(DatabricksConfig config) {
        return new JwtPrivateKeyClientCredentials.Builder().withHttpClient(this.httpClient).withClientId(config.getClientId()).withJwtKid(this.connectionContext.getKID()).withJwtKeyFile(this.connectionContext.getJWTKeyFile()).withJwtKeyPassphrase(this.connectionContext.getJWTPassphrase()).withJwtAlgorithm(this.connectionContext.getJWTAlgorithm()).withTokenUrl(this.tokenEndpoint).withScopes(Collections.singletonList(this.connectionContext.getAuthScope())).build();
    }

    @Override
    public HeaderFactory configure(DatabricksConfig config) {
        JwtPrivateKeyClientCredentials clientCredentials = this.getClientCredentialObject(config);
        return () -> {
            Token token = clientCredentials.getToken();
            HashMap<String, Object> headers = new HashMap<String, Object>();
            headers.put("Authorization", token.getTokenType() + " " + token.getAccessToken());
            headers.put("Content-Type", "application/x-www-form-urlencoded");
            return headers;
        };
    }
}

