/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.common;

public enum TelemetryLogLevel {
    OFF(0),
    FATAL(1),
    ERROR(2),
    WARN(3),
    INFO(4),
    DEBUG(5),
    TRACE(6);

    private final int code;

    private TelemetryLogLevel(int code) {
        this.code = code;
    }

    public int toInt() {
        return this.code;
    }

    public static TelemetryLogLevel fromInt(int code) {
        switch (code) {
            case 0: {
                return OFF;
            }
            case 1: {
                return FATAL;
            }
            case 2: {
                return ERROR;
            }
            case 3: {
                return WARN;
            }
            case 4: {
                return INFO;
            }
            case 5: {
                return DEBUG;
            }
            case 6: {
                return TRACE;
            }
        }
        return DEBUG;
    }

    public static TelemetryLogLevel parse(String value, TelemetryLogLevel defaultLevel) {
        if (value == null) {
            return defaultLevel;
        }
        String v = value.trim();
        if (v.isEmpty()) {
            return defaultLevel;
        }
        try {
            return TelemetryLogLevel.fromInt(Integer.parseInt(v));
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return TelemetryLogLevel.valueOf(v.toUpperCase());
            }
            catch (IllegalArgumentException ignored) {
                return defaultLevel;
            }
        }
    }
}

