/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.common.util;

public class WildcardUtil {
    private static final String ASTERISK = "*";

    public static boolean isMatchAnything(String s2) {
        return ASTERISK.equals(s2);
    }

    public static boolean isNullOrEmpty(String s2) {
        return s2 == null || s2.trim().isEmpty();
    }

    public static boolean isNullOrWildcard(String s2) {
        return s2 == null || WildcardUtil.isWildcard(s2) || s2.equals("%");
    }

    public static boolean isWildcard(String s2) {
        return s2 != null && s2.contains(ASTERISK);
    }

    public static String jdbcPatternToHive(String pattern) {
        if (pattern == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        boolean escapeNext = false;
        block4: for (int i = 0; i < pattern.length(); ++i) {
            char ch = pattern.charAt(i);
            if (ch == '\\') {
                if (i + 1 < pattern.length() && pattern.charAt(i + 1) == '\\') {
                    builder.append("\\\\");
                    ++i;
                    continue;
                }
                escapeNext = !escapeNext;
                continue;
            }
            if (escapeNext) {
                builder.append(ch);
                escapeNext = false;
                continue;
            }
            switch (ch) {
                case '%': {
                    builder.append(ASTERISK);
                    continue block4;
                }
                case '_': {
                    builder.append(".");
                    continue block4;
                }
                default: {
                    builder.append(ch);
                }
            }
        }
        return builder.toString();
    }
}

