/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.dbclient.impl.thrift;

import com.databricks.internal.google.common.annotations.VisibleForTesting;
import com.databricks.internal.sdk.core.DatabricksConfig;
import com.databricks.jdbc.api.impl.DatabricksResultSet;
import com.databricks.jdbc.api.impl.ImmutableSessionInfo;
import com.databricks.jdbc.api.impl.ImmutableSqlParameter;
import com.databricks.jdbc.api.internal.IDatabricksConnectionContext;
import com.databricks.jdbc.api.internal.IDatabricksSession;
import com.databricks.jdbc.api.internal.IDatabricksStatementInternal;
import com.databricks.jdbc.common.EnvironmentVariables;
import com.databricks.jdbc.common.IDatabricksComputeResource;
import com.databricks.jdbc.common.StatementType;
import com.databricks.jdbc.common.util.DatabricksAuthUtil;
import com.databricks.jdbc.common.util.DatabricksThreadContextHolder;
import com.databricks.jdbc.common.util.DatabricksThriftUtil;
import com.databricks.jdbc.common.util.DatabricksTypeUtil;
import com.databricks.jdbc.common.util.DriverUtil;
import com.databricks.jdbc.common.util.ProtocolFeatureUtil;
import com.databricks.jdbc.dbclient.IDatabricksClient;
import com.databricks.jdbc.dbclient.IDatabricksMetadataClient;
import com.databricks.jdbc.dbclient.impl.common.MetadataResultSetBuilder;
import com.databricks.jdbc.dbclient.impl.common.StatementId;
import com.databricks.jdbc.dbclient.impl.sqlexec.CommandBuilder;
import com.databricks.jdbc.dbclient.impl.sqlexec.CommandName;
import com.databricks.jdbc.dbclient.impl.sqlexec.ResultConstants;
import com.databricks.jdbc.dbclient.impl.thrift.DatabricksThriftAccessor;
import com.databricks.jdbc.exception.DatabricksParsingException;
import com.databricks.jdbc.exception.DatabricksSQLException;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import com.databricks.jdbc.model.client.thrift.generated.TCancelOperationReq;
import com.databricks.jdbc.model.client.thrift.generated.TCancelOperationResp;
import com.databricks.jdbc.model.client.thrift.generated.TCloseOperationReq;
import com.databricks.jdbc.model.client.thrift.generated.TCloseOperationResp;
import com.databricks.jdbc.model.client.thrift.generated.TCloseSessionReq;
import com.databricks.jdbc.model.client.thrift.generated.TCloseSessionResp;
import com.databricks.jdbc.model.client.thrift.generated.TExecuteStatementReq;
import com.databricks.jdbc.model.client.thrift.generated.TFetchResultsResp;
import com.databricks.jdbc.model.client.thrift.generated.TGetCatalogsReq;
import com.databricks.jdbc.model.client.thrift.generated.TGetColumnsReq;
import com.databricks.jdbc.model.client.thrift.generated.TGetCrossReferenceReq;
import com.databricks.jdbc.model.client.thrift.generated.TGetFunctionsReq;
import com.databricks.jdbc.model.client.thrift.generated.TGetPrimaryKeysReq;
import com.databricks.jdbc.model.client.thrift.generated.TGetSchemasReq;
import com.databricks.jdbc.model.client.thrift.generated.TGetTablesReq;
import com.databricks.jdbc.model.client.thrift.generated.TNamespace;
import com.databricks.jdbc.model.client.thrift.generated.TOpenSessionReq;
import com.databricks.jdbc.model.client.thrift.generated.TOpenSessionResp;
import com.databricks.jdbc.model.client.thrift.generated.TProtocolVersion;
import com.databricks.jdbc.model.client.thrift.generated.TSparkArrowTypes;
import com.databricks.jdbc.model.client.thrift.generated.TSparkParameter;
import com.databricks.jdbc.model.client.thrift.generated.TSparkParameterValue;
import com.databricks.jdbc.model.core.ExternalLink;
import com.databricks.jdbc.model.core.ResultData;
import com.databricks.jdbc.model.telemetry.enums.DatabricksDriverErrorCode;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class DatabricksThriftServiceClient
implements IDatabricksClient,
IDatabricksMetadataClient {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(DatabricksThriftServiceClient.class);
    private final DatabricksThriftAccessor thriftAccessor;
    private final IDatabricksConnectionContext connectionContext;
    private TProtocolVersion serverProtocolVersion = EnvironmentVariables.JDBC_THRIFT_VERSION;
    private final MetadataResultSetBuilder metadataResultSetBuilder;

    public DatabricksThriftServiceClient(IDatabricksConnectionContext connectionContext) throws DatabricksParsingException {
        this.connectionContext = connectionContext;
        this.thriftAccessor = new DatabricksThriftAccessor(connectionContext);
        this.metadataResultSetBuilder = new MetadataResultSetBuilder(connectionContext);
    }

    @VisibleForTesting
    DatabricksThriftServiceClient(DatabricksThriftAccessor thriftAccessor, IDatabricksConnectionContext connectionContext) {
        this.thriftAccessor = thriftAccessor;
        this.connectionContext = connectionContext;
        this.metadataResultSetBuilder = new MetadataResultSetBuilder(connectionContext);
    }

    @VisibleForTesting
    void setServerProtocolVersion(TProtocolVersion serverProtocolVersion) {
        this.serverProtocolVersion = serverProtocolVersion;
    }

    private boolean isMultipleCatalogSupportEnabled() {
        return this.connectionContext == null || this.connectionContext.getEnableMultipleCatalogSupport();
    }

    @Override
    public IDatabricksConnectionContext getConnectionContext() {
        return this.connectionContext;
    }

    @Override
    public void resetAccessToken(String newAccessToken) {
        DatabricksConfig currentConfig = this.thriftAccessor.getDatabricksConfig();
        DatabricksConfig newConfig = DatabricksAuthUtil.initializeConfigWithToken(newAccessToken, currentConfig);
        newConfig.resolve();
        this.thriftAccessor.updateConfig(newConfig);
    }

    @Override
    public ImmutableSessionInfo createSession(IDatabricksComputeResource cluster, String catalog, String schema, Map<String, String> sessionConf) throws DatabricksSQLException {
        LOGGER.debug(String.format("public Session createSession(Compute cluster = {%s}, String catalog = {%s}, String schema = {%s}, Map<String, String> sessionConf = {%s})", cluster.toString(), catalog, schema, sessionConf));
        TOpenSessionReq openSessionReq = new TOpenSessionReq().setConfiguration(sessionConf).setCanUseMultipleCatalogs(this.isMultipleCatalogSupportEnabled()).setClient_protocol_i64(EnvironmentVariables.JDBC_THRIFT_VERSION.getValue());
        if (catalog != null || schema != null) {
            openSessionReq.setInitialNamespace(this.getNamespace(catalog, schema));
        }
        TOpenSessionResp response = (TOpenSessionResp)this.thriftAccessor.getThriftResponse(openSessionReq);
        DatabricksThriftUtil.verifySuccessStatus(response.status, response.toString());
        this.serverProtocolVersion = response.getServerProtocolVersion();
        this.thriftAccessor.setServerProtocolVersion(this.serverProtocolVersion);
        if (ProtocolFeatureUtil.isNonDatabricksCompute(this.serverProtocolVersion)) {
            throw new DatabricksSQLException("Attempting to connect to a non Databricks compute using the Databricks driver.", DatabricksDriverErrorCode.UNSUPPORTED_OPERATION);
        }
        String sessionId = DatabricksThriftUtil.byteBufferToString(response.sessionHandle.getSessionId().guid);
        DatabricksThreadContextHolder.setSessionId(sessionId);
        LOGGER.debug("Session created with ID {}", sessionId);
        return ImmutableSessionInfo.builder().sessionId(sessionId).sessionHandle(response.sessionHandle).computeResource(cluster).build();
    }

    @Override
    public void deleteSession(ImmutableSessionInfo sessionInfo) throws DatabricksSQLException {
        LOGGER.debug(String.format("public void deleteSession(Session session = {%s}))", sessionInfo.toString()));
        DatabricksThreadContextHolder.setSessionId(sessionInfo.sessionId());
        TCloseSessionReq closeSessionReq = new TCloseSessionReq().setSessionHandle(sessionInfo.sessionHandle());
        TCloseSessionResp response = (TCloseSessionResp)this.thriftAccessor.getThriftResponse(closeSessionReq);
        DatabricksThriftUtil.verifySuccessStatus(response.status, response.toString());
    }

    @Override
    public DatabricksResultSet executeStatement(String sql, IDatabricksComputeResource computeResource, Map<Integer, ImmutableSqlParameter> parameters, StatementType statementType, IDatabricksSession session, IDatabricksStatementInternal parentStatement) throws SQLException {
        LOGGER.debug(String.format("public DatabricksResultSet executeStatement(String sql = {%s}, Compute cluster = {%s}, Map<Integer, ImmutableSqlParameter> parameters = {%s}, StatementType statementType = {%s}, IDatabricksSession session)", new Object[]{sql, computeResource, parameters.toString(), statementType}));
        DatabricksThreadContextHolder.setStatementType(statementType);
        TExecuteStatementReq request = this.getRequest(sql, parameters, session, parentStatement, false);
        return this.thriftAccessor.execute(request, parentStatement, session, statementType);
    }

    @Override
    public DatabricksResultSet executeStatementAsync(String sql, IDatabricksComputeResource computeResource, Map<Integer, ImmutableSqlParameter> parameters, IDatabricksSession session, IDatabricksStatementInternal parentStatement) throws SQLException {
        LOGGER.debug(String.format("public DatabricksResultSet executeStatementAsync(String sql = {%s}, Compute cluster = {%s}, Map<Integer, ImmutableSqlParameter> parameters = {%s})", sql, computeResource.toString(), parameters.toString()));
        TExecuteStatementReq request = this.getRequest(sql, parameters, session, parentStatement, true);
        return this.thriftAccessor.executeAsync(request, parentStatement, session, StatementType.SQL);
    }

    @VisibleForTesting
    TSparkParameter mapToSparkParameterListItem(ImmutableSqlParameter parameter) {
        Object value = parameter.value();
        String typeString = parameter.type().name();
        if (typeString.equals("DECIMAL") && value instanceof BigDecimal) {
            typeString = DatabricksTypeUtil.getDecimalTypeString((BigDecimal)value);
        }
        return new TSparkParameter().setOrdinal(parameter.cardinal()).setType(typeString).setValue(value != null ? TSparkParameterValue.stringValue(value.toString()) : null);
    }

    private TExecuteStatementReq getRequest(String sql, Map<Integer, ImmutableSqlParameter> parameters, IDatabricksSession session, IDatabricksStatementInternal parentStatement, boolean runAsync) throws SQLException {
        int maxRows;
        DatabricksThreadContextHolder.setSessionId(session.getSessionId());
        TSparkArrowTypes arrowNativeTypes = new TSparkArrowTypes().setTimestampAsArrow(true);
        List<TSparkParameter> sparkParameters = parameters.values().stream().map(this::mapToSparkParameterListItem).collect(Collectors.toList());
        int timeout = 0;
        if (parentStatement != null && parentStatement.getStatement() != null) {
            timeout = parentStatement.getStatement().getQueryTimeout();
        }
        TExecuteStatementReq request = new TExecuteStatementReq().setStatement(sql).setQueryTimeout(timeout).setSessionHandle(Objects.requireNonNull(session.getSessionInfo()).sessionHandle()).setCanReadArrowResult(this.connectionContext.shouldEnableArrow()).setUseArrowNativeTypes(arrowNativeTypes);
        if (ProtocolFeatureUtil.supportsParameterizedQueries(this.serverProtocolVersion)) {
            request.setParameters(sparkParameters);
        }
        if (ProtocolFeatureUtil.supportsCompressedArrowBatches(this.serverProtocolVersion)) {
            request.setCanDecompressLZ4Result(true);
        }
        if (ProtocolFeatureUtil.supportsCloudFetch(this.serverProtocolVersion)) {
            request.setCanDownloadResult(true);
        }
        if (ProtocolFeatureUtil.supportsAdvancedArrowTypes(this.serverProtocolVersion)) {
            arrowNativeTypes.setComplexTypesAsArrow(true).setIntervalTypesAsArrow(true).setNullTypeAsArrow(true).setDecimalAsArrow(true);
            request.setUseArrowNativeTypes(arrowNativeTypes);
        }
        int n = maxRows = parentStatement == null ? 0 : parentStatement.getMaxRows();
        if (maxRows > 0) {
            request.setResultRowLimit(maxRows);
        }
        if (runAsync || !DriverUtil.isRunningAgainstFake()) {
            request.setRunAsync(true);
        }
        return request;
    }

    @Override
    public void closeStatement(StatementId statementId) throws DatabricksSQLException {
        LOGGER.debug(String.format("public void closeStatement(String statementId = {%s}) using Thrift client", statementId));
        DatabricksThreadContextHolder.setStatementId(statementId);
        TCloseOperationReq request = new TCloseOperationReq().setOperationHandle(DatabricksThriftUtil.getOperationHandle(statementId));
        TCloseOperationResp resp = this.thriftAccessor.closeOperation(request);
        LOGGER.debug("Statement {} closed with status {}", statementId, resp.getStatus());
    }

    @Override
    public void cancelStatement(StatementId statementId) throws DatabricksSQLException {
        LOGGER.debug(String.format("public void cancelStatement(String statementId = {%s}) using Thrift client", statementId));
        DatabricksThreadContextHolder.setStatementId(statementId);
        TCancelOperationReq request = new TCancelOperationReq().setOperationHandle(DatabricksThriftUtil.getOperationHandle(statementId));
        TCancelOperationResp resp = this.thriftAccessor.cancelOperation(request);
        LOGGER.debug("Statement {} cancelled with status {}", statementId, resp.getStatus());
    }

    @Override
    public DatabricksResultSet getStatementResult(StatementId statementId, IDatabricksSession session, IDatabricksStatementInternal parentStatement) throws SQLException {
        LOGGER.debug(String.format("public DatabricksResultSet getStatementResult(String statementId = {%s}) using Thrift client", statementId));
        DatabricksThreadContextHolder.setStatementId(statementId);
        DatabricksThreadContextHolder.setSessionId(session.getSessionId());
        return this.thriftAccessor.getStatementResult(DatabricksThriftUtil.getOperationHandle(statementId), parentStatement, session);
    }

    @Override
    public Collection<ExternalLink> getResultChunks(StatementId statementId, long chunkIndex) throws DatabricksSQLException {
        TFetchResultsResp fetchResultsResp;
        String context = String.format("public Optional<ExternalLink> getResultChunk(String statementId = {%s}, long chunkIndex = {%s}) using Thrift client", statementId, chunkIndex);
        LOGGER.debug(context);
        DatabricksThreadContextHolder.setStatementId(statementId);
        ArrayList<ExternalLink> externalLinks = new ArrayList<ExternalLink>();
        AtomicInteger index = new AtomicInteger(0);
        do {
            fetchResultsResp = this.thriftAccessor.getResultSetResp(DatabricksThriftUtil.getOperationHandle(statementId), context);
            fetchResultsResp.getResults().getResultLinks().forEach(resultLink -> externalLinks.add(DatabricksThriftUtil.createExternalLink(resultLink, index.getAndIncrement())));
        } while (fetchResultsResp.hasMoreRows);
        if (chunkIndex < 0L || (long)externalLinks.size() <= chunkIndex) {
            String error = String.format("Out of bounds error for chunkIndex. Context: %s", context);
            LOGGER.error(error);
            throw new DatabricksSQLException(error, DatabricksDriverErrorCode.INVALID_STATE);
        }
        return externalLinks;
    }

    @Override
    public ResultData getResultChunksData(StatementId statementId, long chunkIndex) throws DatabricksSQLException {
        throw new DatabricksSQLException("getResultChunksData method is not yet implemented for thrift client", DatabricksDriverErrorCode.INVALID_STATE);
    }

    @Override
    public DatabricksResultSet listTypeInfo(IDatabricksSession session) {
        LOGGER.debug("public ResultSet getTypeInfo()");
        return ResultConstants.TYPE_INFO_RESULT;
    }

    @Override
    public DatabricksResultSet listCatalogs(IDatabricksSession session) throws SQLException {
        String context = String.format("Fetching catalogs using Thrift client. Session {%s}", session.toString());
        LOGGER.debug(context);
        DatabricksThreadContextHolder.setSessionId(session.getSessionId());
        if (!this.isMultipleCatalogSupportEnabled()) {
            String currentCatalog = session.getCurrentCatalog();
            if (currentCatalog == null || currentCatalog.isEmpty()) {
                currentCatalog = "";
            }
            ArrayList<List<Object>> singleCatalogRows = new ArrayList<List<Object>>();
            ArrayList<String> catalogRow = new ArrayList<String>();
            catalogRow.add(currentCatalog);
            singleCatalogRows.add(catalogRow);
            return this.metadataResultSetBuilder.getCatalogsResult(singleCatalogRows);
        }
        TGetCatalogsReq request = new TGetCatalogsReq().setSessionHandle(Objects.requireNonNull(session.getSessionInfo()).sessionHandle());
        if (ProtocolFeatureUtil.supportsAsyncMetadataExecution(this.serverProtocolVersion)) {
            request.setRunAsync(true);
        }
        TFetchResultsResp response = (TFetchResultsResp)this.thriftAccessor.getThriftResponse(request);
        return this.metadataResultSetBuilder.getCatalogsResult(DatabricksThriftUtil.extractRowsFromColumnar(response.getResults()));
    }

    @Override
    public DatabricksResultSet listSchemas(IDatabricksSession session, String catalog, String schemaNamePattern) throws SQLException {
        String context = String.format("Fetching schemas using Thrift client. Session {%s}, catalog {%s}, schemaNamePattern {%s}", session.toString(), catalog, schemaNamePattern);
        LOGGER.debug(context);
        DatabricksThreadContextHolder.setSessionId(session.getSessionId());
        TGetSchemasReq request = new TGetSchemasReq().setSessionHandle(Objects.requireNonNull(session.getSessionInfo()).sessionHandle()).setCatalogName(catalog);
        if (schemaNamePattern != null) {
            request.setSchemaName(schemaNamePattern);
        }
        if (ProtocolFeatureUtil.supportsAsyncMetadataExecution(this.serverProtocolVersion)) {
            request.setRunAsync(true);
        }
        TFetchResultsResp response = (TFetchResultsResp)this.thriftAccessor.getThriftResponse(request);
        return this.metadataResultSetBuilder.getSchemasResult(DatabricksThriftUtil.extractRowsFromColumnar(response.getResults()));
    }

    @Override
    public DatabricksResultSet listTables(IDatabricksSession session, String catalog, String schemaNamePattern, String tableNamePattern, String[] tableTypes) throws SQLException {
        String context = String.format("Fetching tables using Thrift client. Session {%s}, catalog {%s}, schemaNamePattern {%s}, tableNamePattern {%s}", session.toString(), catalog, schemaNamePattern, tableNamePattern);
        LOGGER.debug(context);
        DatabricksThreadContextHolder.setSessionId(session.getSessionId());
        TGetTablesReq request = new TGetTablesReq().setSessionHandle(Objects.requireNonNull(session.getSessionInfo()).sessionHandle()).setCatalogName(catalog).setSchemaName(schemaNamePattern).setTableName(tableNamePattern);
        if (tableTypes != null) {
            request.setTableTypes(Arrays.asList(tableTypes));
        }
        if (ProtocolFeatureUtil.supportsAsyncMetadataExecution(this.serverProtocolVersion)) {
            request.setRunAsync(true);
        }
        TFetchResultsResp response = (TFetchResultsResp)this.thriftAccessor.getThriftResponse(request);
        return this.metadataResultSetBuilder.getTablesResult(catalog, tableTypes, DatabricksThriftUtil.extractRowsFromColumnar(response.getResults()));
    }

    @Override
    public DatabricksResultSet listTableTypes(IDatabricksSession session) {
        LOGGER.debug(String.format("Fetching table types using Thrift client. Session {%s}", session.toString()));
        DatabricksThreadContextHolder.setSessionId(session.getSessionId());
        return this.metadataResultSetBuilder.getTableTypesResult();
    }

    @Override
    public DatabricksResultSet listColumns(IDatabricksSession session, String catalog, String schemaNamePattern, String tableNamePattern, String columnNamePattern) throws DatabricksSQLException {
        String context = String.format("Fetching columns using Thrift client. Session {%s}, catalog {%s}, schemaNamePattern {%s}, tableNamePattern {%s}, columnNamePattern {%s}", session.toString(), catalog, schemaNamePattern, tableNamePattern, columnNamePattern);
        LOGGER.debug(context);
        DatabricksThreadContextHolder.setSessionId(session.getSessionId());
        TGetColumnsReq request = new TGetColumnsReq().setSessionHandle(Objects.requireNonNull(session.getSessionInfo()).sessionHandle()).setCatalogName(catalog).setSchemaName(schemaNamePattern).setTableName(tableNamePattern).setColumnName(columnNamePattern);
        if (ProtocolFeatureUtil.supportsAsyncMetadataExecution(this.serverProtocolVersion)) {
            request.setRunAsync(true);
        }
        TFetchResultsResp response = (TFetchResultsResp)this.thriftAccessor.getThriftResponse(request);
        return this.metadataResultSetBuilder.getColumnsResult(DatabricksThriftUtil.extractRowsFromColumnar(response.getResults()));
    }

    @Override
    public DatabricksResultSet listFunctions(IDatabricksSession session, String catalog, String schemaNamePattern, String functionNamePattern) throws SQLException {
        String context = String.format("Fetching functions using Thrift client. Session {%s}, catalog {%s}, schemaNamePattern {%s}, functionNamePattern {%s}.", session.toString(), catalog, schemaNamePattern, functionNamePattern);
        DatabricksThreadContextHolder.setSessionId(session.getSessionId());
        LOGGER.debug(context);
        if (this.connectionContext.enableShowCommandsForGetFunctions()) {
            String showFunctionsSqlCommand = new CommandBuilder(catalog, session).setSchemaPattern(schemaNamePattern).setFunctionPattern(functionNamePattern).getSQLString(CommandName.LIST_FUNCTIONS);
            LOGGER.debug("Fetching functions using SQL Command {{}}. Session {{}}", showFunctionsSqlCommand, session.toString());
            try (DatabricksResultSet rs = this.executeStatement(showFunctionsSqlCommand, session.getComputeResource(), Collections.emptyMap(), StatementType.METADATA, session, null);){
                DatabricksResultSet databricksResultSet = this.metadataResultSetBuilder.getFunctionsResult(rs, catalog);
                return databricksResultSet;
            }
        }
        TGetFunctionsReq request = new TGetFunctionsReq().setSessionHandle(Objects.requireNonNull(session.getSessionInfo()).sessionHandle()).setCatalogName(catalog).setSchemaName(schemaNamePattern).setFunctionName(functionNamePattern);
        if (ProtocolFeatureUtil.supportsAsyncMetadataExecution(this.serverProtocolVersion)) {
            request.setRunAsync(true);
        }
        TFetchResultsResp response = (TFetchResultsResp)this.thriftAccessor.getThriftResponse(request);
        return this.metadataResultSetBuilder.getFunctionsResult(catalog, DatabricksThriftUtil.extractRowsFromColumnar(response.getResults()));
    }

    @Override
    public DatabricksResultSet listPrimaryKeys(IDatabricksSession session, String catalog, String schema, String table) throws SQLException {
        String context = String.format("Fetching primary keys using Thrift client. session {%s}, catalog {%s}, schema {%s}, table {%s}", session.toString(), catalog, schema, table);
        LOGGER.debug(context);
        DatabricksThreadContextHolder.setSessionId(session.getSessionId());
        TGetPrimaryKeysReq request = new TGetPrimaryKeysReq().setSessionHandle(Objects.requireNonNull(session.getSessionInfo()).sessionHandle()).setCatalogName(catalog).setSchemaName(schema).setTableName(table);
        if (ProtocolFeatureUtil.supportsAsyncMetadataExecution(this.serverProtocolVersion)) {
            request.setRunAsync(true);
        }
        TFetchResultsResp response = (TFetchResultsResp)this.thriftAccessor.getThriftResponse(request);
        return this.metadataResultSetBuilder.getPrimaryKeysResult(DatabricksThriftUtil.extractRowsFromColumnar(response.getResults()));
    }

    @Override
    public DatabricksResultSet listImportedKeys(IDatabricksSession session, String catalog, String schema, String table) throws SQLException {
        String context = String.format("Fetching imported keys using Thrift client for session {%s}, catalog {%s}, schema {%s}, table {%s}", session.toString(), catalog, schema, table);
        LOGGER.debug(context);
        DatabricksThreadContextHolder.setSessionId(session.getSessionId());
        TGetCrossReferenceReq request = new TGetCrossReferenceReq().setSessionHandle(Objects.requireNonNull(session.getSessionInfo()).sessionHandle()).setForeignCatalogName(catalog).setForeignSchemaName(schema).setForeignTableName(table);
        if (ProtocolFeatureUtil.supportsAsyncMetadataExecution(this.serverProtocolVersion)) {
            request.setRunAsync(true);
        }
        TFetchResultsResp response = (TFetchResultsResp)this.thriftAccessor.getThriftResponse(request);
        return this.metadataResultSetBuilder.getImportedKeys(DatabricksThriftUtil.extractRowsFromColumnar(response.getResults()));
    }

    @Override
    public DatabricksResultSet listExportedKeys(IDatabricksSession session, String catalog, String schema, String table) throws SQLException {
        String context = String.format("Fetching exported keys using Thrift client for session {%s}, catalog {%s}, schema {%s}, table {%s}", session.toString(), catalog, schema, table);
        LOGGER.debug(context);
        TGetCrossReferenceReq request = new TGetCrossReferenceReq().setSessionHandle(Objects.requireNonNull(session.getSessionInfo()).sessionHandle()).setParentCatalogName(catalog).setParentSchemaName(schema).setParentTableName(table);
        if (ProtocolFeatureUtil.supportsAsyncMetadataExecution(this.serverProtocolVersion)) {
            request.setRunAsync(true);
        }
        TFetchResultsResp response = (TFetchResultsResp)this.thriftAccessor.getThriftResponse(request);
        return this.metadataResultSetBuilder.getExportedKeys(DatabricksThriftUtil.extractRowsFromColumnar(response.getResults()));
    }

    @Override
    public DatabricksResultSet listCrossReferences(IDatabricksSession session, String parentCatalog, String parentSchema, String parentTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        String context = String.format("Fetching cross references using Thrift client for session {%s}, catalog {%s}, schema {%s}, table {%s}, foreign catalog {%s}, foreign schema {%s}, foreign table {%s}", session.toString(), parentCatalog, parentSchema, parentTable, foreignCatalog, foreignSchema, foreignTable);
        LOGGER.debug(context);
        TGetCrossReferenceReq request = new TGetCrossReferenceReq().setSessionHandle(Objects.requireNonNull(session.getSessionInfo()).sessionHandle()).setParentCatalogName(parentCatalog).setParentSchemaName(parentSchema).setParentTableName(parentTable).setForeignCatalogName(foreignCatalog).setForeignSchemaName(foreignSchema).setForeignTableName(foreignTable);
        if (ProtocolFeatureUtil.supportsAsyncMetadataExecution(this.serverProtocolVersion)) {
            request.setRunAsync(true);
        }
        TFetchResultsResp response = (TFetchResultsResp)this.thriftAccessor.getThriftResponse(request);
        return this.metadataResultSetBuilder.getCrossRefsResult(DatabricksThriftUtil.extractRowsFromColumnar(response.getResults()));
    }

    @Override
    public TFetchResultsResp getMoreResults(IDatabricksStatementInternal parentStatement) throws DatabricksSQLException {
        return this.thriftAccessor.getMoreResults(parentStatement);
    }

    @Override
    public DatabricksConfig getDatabricksConfig() {
        return this.thriftAccessor.getDatabricksConfig();
    }

    private TNamespace getNamespace(String catalog, String schema) {
        TNamespace namespace = new TNamespace();
        if (catalog != null) {
            namespace.setCatalogName(catalog);
        }
        if (schema != null) {
            namespace.setSchemaName(schema);
        }
        return namespace;
    }
}

