/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.exception;

import com.databricks.jdbc.common.TelemetryLogLevel;
import com.databricks.jdbc.common.util.DatabricksThreadContextHolder;
import com.databricks.jdbc.exception.DatabricksVendorCode;
import com.databricks.jdbc.model.telemetry.enums.DatabricksDriverErrorCode;
import com.databricks.jdbc.telemetry.TelemetryHelper;
import java.sql.SQLException;

public class DatabricksTransactionException
extends SQLException {
    public DatabricksTransactionException(String reason, String sqlState, int vendorCode, Throwable cause) {
        super(reason, sqlState, vendorCode, cause);
        this.logTelemetryEvent(sqlState, reason);
    }

    public DatabricksTransactionException(String reason, Throwable cause, DatabricksDriverErrorCode internalError) {
        this(reason, DatabricksTransactionException.getSqlStateFromCause(cause, internalError), DatabricksTransactionException.getVendorCodeFromCause(cause), cause);
    }

    private static String getSqlStateFromCause(Throwable cause, DatabricksDriverErrorCode internalError) {
        String sqlState;
        if (cause instanceof SQLException && (sqlState = ((SQLException)cause).getSQLState()) != null && !sqlState.isEmpty()) {
            return sqlState;
        }
        return internalError.name();
    }

    private static int getVendorCodeFromCause(Throwable cause) {
        int vendorCode;
        if (cause instanceof SQLException && (vendorCode = ((SQLException)cause).getErrorCode()) != 0) {
            return vendorCode;
        }
        return DatabricksVendorCode.getVendorCode(cause);
    }

    private void logTelemetryEvent(String sqlState, String reason) {
        TelemetryHelper.exportFailureLog(DatabricksThreadContextHolder.getConnectionContext(), sqlState, reason, TelemetryLogLevel.ERROR);
    }
}

