/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.io.github.resilience4j.circuitbreaker;

import com.databricks.internal.io.github.resilience4j.circuitbreaker.CircuitBreaker;
import com.databricks.internal.io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import com.databricks.internal.io.github.resilience4j.circuitbreaker.internal.InMemoryCircuitBreakerRegistry;
import com.databricks.internal.io.github.resilience4j.core.Registry;
import com.databricks.internal.io.github.resilience4j.core.RegistryStore;
import com.databricks.internal.io.github.resilience4j.core.registry.RegistryEventConsumer;
import com.databricks.internal.io.vavr.collection.Seq;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public interface CircuitBreakerRegistry
extends Registry<CircuitBreaker, CircuitBreakerConfig> {
    public static CircuitBreakerRegistry of(CircuitBreakerConfig circuitBreakerConfig) {
        return new InMemoryCircuitBreakerRegistry(circuitBreakerConfig);
    }

    public static CircuitBreakerRegistry of(CircuitBreakerConfig circuitBreakerConfig, RegistryEventConsumer<CircuitBreaker> registryEventConsumer) {
        return new InMemoryCircuitBreakerRegistry(circuitBreakerConfig, registryEventConsumer);
    }

    public static CircuitBreakerRegistry of(CircuitBreakerConfig circuitBreakerConfig, List<RegistryEventConsumer<CircuitBreaker>> registryEventConsumers) {
        return new InMemoryCircuitBreakerRegistry(circuitBreakerConfig, registryEventConsumers);
    }

    public static CircuitBreakerRegistry of(Map<String, CircuitBreakerConfig> configs) {
        return CircuitBreakerRegistry.of(configs, com.databricks.internal.io.vavr.collection.HashMap.empty());
    }

    public static CircuitBreakerRegistry of(Map<String, CircuitBreakerConfig> configs, com.databricks.internal.io.vavr.collection.Map<String, String> tags) {
        return new InMemoryCircuitBreakerRegistry(configs, tags);
    }

    public static CircuitBreakerRegistry of(Map<String, CircuitBreakerConfig> configs, RegistryEventConsumer<CircuitBreaker> registryEventConsumer) {
        return new InMemoryCircuitBreakerRegistry(configs, registryEventConsumer);
    }

    public static CircuitBreakerRegistry of(Map<String, CircuitBreakerConfig> configs, RegistryEventConsumer<CircuitBreaker> registryEventConsumer, com.databricks.internal.io.vavr.collection.Map<String, String> tags) {
        return new InMemoryCircuitBreakerRegistry(configs, registryEventConsumer, tags);
    }

    public static CircuitBreakerRegistry of(Map<String, CircuitBreakerConfig> configs, List<RegistryEventConsumer<CircuitBreaker>> registryEventConsumers) {
        return new InMemoryCircuitBreakerRegistry(configs, registryEventConsumers);
    }

    public static CircuitBreakerRegistry ofDefaults() {
        return new InMemoryCircuitBreakerRegistry();
    }

    public Seq<CircuitBreaker> getAllCircuitBreakers();

    public CircuitBreaker circuitBreaker(String var1);

    public CircuitBreaker circuitBreaker(String var1, com.databricks.internal.io.vavr.collection.Map<String, String> var2);

    public CircuitBreaker circuitBreaker(String var1, CircuitBreakerConfig var2);

    public CircuitBreaker circuitBreaker(String var1, CircuitBreakerConfig var2, com.databricks.internal.io.vavr.collection.Map<String, String> var3);

    public CircuitBreaker circuitBreaker(String var1, String var2);

    public CircuitBreaker circuitBreaker(String var1, String var2, com.databricks.internal.io.vavr.collection.Map<String, String> var3);

    public CircuitBreaker circuitBreaker(String var1, Supplier<CircuitBreakerConfig> var2);

    public CircuitBreaker circuitBreaker(String var1, Supplier<CircuitBreakerConfig> var2, com.databricks.internal.io.vavr.collection.Map<String, String> var3);

    public static Builder custom() {
        return new Builder();
    }

    public static class Builder {
        private static final String DEFAULT_CONFIG = "default";
        private RegistryStore<CircuitBreaker> registryStore;
        private Map<String, CircuitBreakerConfig> circuitBreakerConfigsMap = new HashMap<String, CircuitBreakerConfig>();
        private List<RegistryEventConsumer<CircuitBreaker>> registryEventConsumers = new ArrayList<RegistryEventConsumer<CircuitBreaker>>();
        private com.databricks.internal.io.vavr.collection.Map<String, String> tags;

        public Builder withRegistryStore(RegistryStore<CircuitBreaker> registryStore) {
            this.registryStore = registryStore;
            return this;
        }

        public Builder withCircuitBreakerConfig(CircuitBreakerConfig circuitBreakerConfig) {
            this.circuitBreakerConfigsMap.put(DEFAULT_CONFIG, circuitBreakerConfig);
            return this;
        }

        public Builder addCircuitBreakerConfig(String configName, CircuitBreakerConfig configuration) {
            if (configName.equals(DEFAULT_CONFIG)) {
                throw new IllegalArgumentException("You cannot add another configuration with name 'default' as it is preserved for default configuration");
            }
            this.circuitBreakerConfigsMap.put(configName, configuration);
            return this;
        }

        public Builder addRegistryEventConsumer(RegistryEventConsumer<CircuitBreaker> registryEventConsumer) {
            this.registryEventConsumers.add(registryEventConsumer);
            return this;
        }

        public Builder withTags(com.databricks.internal.io.vavr.collection.Map<String, String> tags) {
            this.tags = tags;
            return this;
        }

        public CircuitBreakerRegistry build() {
            return new InMemoryCircuitBreakerRegistry(this.circuitBreakerConfigsMap, this.registryEventConsumers, this.tags, this.registryStore);
        }
    }
}

