/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.algorithm;

import com.databricks.internal.jts.algorithm.InteriorPointArea;
import com.databricks.internal.jts.algorithm.InteriorPointLine;
import com.databricks.internal.jts.algorithm.InteriorPointPoint;
import com.databricks.internal.jts.geom.Coordinate;
import com.databricks.internal.jts.geom.Geometry;
import com.databricks.internal.jts.geom.GeometryCollection;
import com.databricks.internal.jts.geom.GeometryFilter;

public class InteriorPoint {
    public static Coordinate getInteriorPoint(Geometry geom) {
        if (geom.isEmpty()) {
            return null;
        }
        Coordinate interiorPt = null;
        int dim = InteriorPoint.dimensionNonEmpty(geom);
        if (dim < 0) {
            return null;
        }
        interiorPt = dim == 0 ? InteriorPointPoint.getInteriorPoint(geom) : (dim == 1 ? InteriorPointLine.getInteriorPoint(geom) : InteriorPointArea.getInteriorPoint(geom));
        return interiorPt;
    }

    private static int dimensionNonEmpty(Geometry geom) {
        DimensionNonEmptyFilter dimFilter = new DimensionNonEmptyFilter();
        geom.apply(dimFilter);
        return dimFilter.getDimension();
    }

    private static class DimensionNonEmptyFilter
    implements GeometryFilter {
        private int dim = -1;

        private DimensionNonEmptyFilter() {
        }

        public int getDimension() {
            return this.dim;
        }

        @Override
        public void filter(Geometry elem) {
            int elemDim;
            if (elem instanceof GeometryCollection) {
                return;
            }
            if (!elem.isEmpty() && (elemDim = elem.getDimension()) > this.dim) {
                this.dim = elemDim;
            }
        }
    }
}

