/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.io;

import com.databricks.internal.jts.io.ByteOrderValues;
import com.databricks.internal.jts.io.InStream;
import com.databricks.internal.jts.io.ParseException;
import java.io.IOException;

public class ByteOrderDataInStream {
    private int byteOrder = 1;
    private InStream stream;
    private byte[] buf1 = new byte[1];
    private byte[] buf4 = new byte[4];
    private byte[] buf8 = new byte[8];
    private byte[] bufLast = null;
    private long count = 0L;

    public ByteOrderDataInStream() {
        this.stream = null;
    }

    public ByteOrderDataInStream(InStream stream) {
        this.stream = stream;
    }

    public void setInStream(InStream stream) {
        this.stream = stream;
    }

    public void setOrder(int byteOrder) {
        this.byteOrder = byteOrder;
    }

    public long getCount() {
        return this.count;
    }

    public byte[] getData() {
        return this.bufLast;
    }

    public byte readByte() throws IOException, ParseException {
        this.read(this.buf1);
        return this.buf1[0];
    }

    public int readInt() throws IOException, ParseException {
        this.read(this.buf4);
        return ByteOrderValues.getInt(this.buf4, this.byteOrder);
    }

    public long readLong() throws IOException, ParseException {
        this.read(this.buf8);
        return ByteOrderValues.getLong(this.buf8, this.byteOrder);
    }

    public double readDouble() throws IOException, ParseException {
        this.read(this.buf8);
        return ByteOrderValues.getDouble(this.buf8, this.byteOrder);
    }

    private void read(byte[] buf) throws IOException, ParseException {
        int num = this.stream.read(buf);
        if (num < buf.length) {
            throw new ParseException("Attempt to read past end of input");
        }
        this.bufLast = buf;
        this.count += (long)num;
    }
}

