/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.noding.snapround;

import com.databricks.internal.jts.geom.Coordinate;
import com.databricks.internal.jts.geom.Envelope;
import com.databricks.internal.jts.index.ItemVisitor;
import com.databricks.internal.jts.index.SpatialIndex;
import com.databricks.internal.jts.index.chain.MonotoneChain;
import com.databricks.internal.jts.index.chain.MonotoneChainSelectAction;
import com.databricks.internal.jts.noding.NodedSegmentString;
import com.databricks.internal.jts.noding.SegmentString;
import com.databricks.internal.jts.noding.snapround.HotPixel;

public class MCIndexPointSnapper {
    private SpatialIndex index;
    private static final double SAFE_ENV_EXPANSION_FACTOR = 0.75;

    public MCIndexPointSnapper(SpatialIndex index) {
        this.index = index;
    }

    public boolean snap(HotPixel hotPixel, SegmentString parentEdge, int hotPixelVertexIndex) {
        final Envelope pixelEnv = this.getSafeEnvelope(hotPixel);
        final HotPixelSnapAction hotPixelSnapAction = new HotPixelSnapAction(hotPixel, parentEdge, hotPixelVertexIndex);
        this.index.query(pixelEnv, new ItemVisitor(){

            @Override
            public void visitItem(Object item) {
                MonotoneChain testChain = (MonotoneChain)item;
                testChain.select(pixelEnv, hotPixelSnapAction);
            }
        });
        return hotPixelSnapAction.isNodeAdded();
    }

    public boolean snap(HotPixel hotPixel) {
        return this.snap(hotPixel, null, -1);
    }

    public Envelope getSafeEnvelope(HotPixel hp) {
        double safeTolerance = 0.75 / hp.getScaleFactor();
        Envelope safeEnv = new Envelope(hp.getCoordinate());
        safeEnv.expandBy(safeTolerance);
        return safeEnv;
    }

    public static class HotPixelSnapAction
    extends MonotoneChainSelectAction {
        private HotPixel hotPixel;
        private SegmentString parentEdge;
        private int hotPixelVertexIndex;
        private boolean isNodeAdded = false;

        public HotPixelSnapAction(HotPixel hotPixel, SegmentString parentEdge, int hotPixelVertexIndex) {
            this.hotPixel = hotPixel;
            this.parentEdge = parentEdge;
            this.hotPixelVertexIndex = hotPixelVertexIndex;
        }

        public boolean isNodeAdded() {
            return this.isNodeAdded;
        }

        @Override
        public void select(MonotoneChain mc, int startIndex) {
            NodedSegmentString ss = (NodedSegmentString)mc.getContext();
            if (this.parentEdge != null && ss == this.parentEdge && (startIndex == this.hotPixelVertexIndex || startIndex + 1 == this.hotPixelVertexIndex)) {
                return;
            }
            this.isNodeAdded |= this.addSnappedNode(this.hotPixel, ss, startIndex);
        }

        public boolean addSnappedNode(HotPixel hotPixel, NodedSegmentString segStr, int segIndex) {
            Coordinate p1;
            Coordinate p0 = segStr.getCoordinate(segIndex);
            if (hotPixel.intersects(p0, p1 = segStr.getCoordinate(segIndex + 1))) {
                segStr.addIntersection(hotPixel.getCoordinate(), segIndex);
                return true;
            }
            return false;
        }
    }
}

