/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.operation.predicate;

import com.databricks.internal.jts.geom.Envelope;
import com.databricks.internal.jts.geom.Geometry;
import com.databricks.internal.jts.geom.util.ShortCircuitedGeometryVisitor;

class EnvelopeIntersectsVisitor
extends ShortCircuitedGeometryVisitor {
    private Envelope rectEnv;
    private boolean intersects = false;

    public EnvelopeIntersectsVisitor(Envelope rectEnv) {
        this.rectEnv = rectEnv;
    }

    public boolean intersects() {
        return this.intersects;
    }

    @Override
    protected void visit(Geometry element) {
        Envelope elementEnv = element.getEnvelopeInternal();
        if (!this.rectEnv.intersects(elementEnv)) {
            return;
        }
        if (this.rectEnv.contains(elementEnv)) {
            this.intersects = true;
            return;
        }
        if (elementEnv.getMinX() >= this.rectEnv.getMinX() && elementEnv.getMaxX() <= this.rectEnv.getMaxX()) {
            this.intersects = true;
            return;
        }
        if (elementEnv.getMinY() >= this.rectEnv.getMinY() && elementEnv.getMaxY() <= this.rectEnv.getMaxY()) {
            this.intersects = true;
            return;
        }
    }

    @Override
    protected boolean isDone() {
        return this.intersects;
    }
}

