/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.operation.relate;

import com.databricks.internal.jts.geomgraph.Edge;
import com.databricks.internal.jts.geomgraph.EdgeEnd;
import com.databricks.internal.jts.geomgraph.EdgeIntersection;
import com.databricks.internal.jts.geomgraph.GeometryGraph;
import com.databricks.internal.jts.geomgraph.Node;
import com.databricks.internal.jts.geomgraph.NodeMap;
import com.databricks.internal.jts.operation.relate.EdgeEndBuilder;
import com.databricks.internal.jts.operation.relate.RelateNode;
import com.databricks.internal.jts.operation.relate.RelateNodeFactory;
import java.util.Iterator;
import java.util.List;

public class RelateNodeGraph {
    private NodeMap nodes = new NodeMap(new RelateNodeFactory());

    public Iterator getNodeIterator() {
        return this.nodes.iterator();
    }

    public void build(GeometryGraph geomGraph) {
        this.computeIntersectionNodes(geomGraph, 0);
        this.copyNodesAndLabels(geomGraph, 0);
        EdgeEndBuilder eeBuilder = new EdgeEndBuilder();
        List eeList = eeBuilder.computeEdgeEnds(geomGraph.getEdgeIterator());
        this.insertEdgeEnds(eeList);
    }

    public void computeIntersectionNodes(GeometryGraph geomGraph, int argIndex) {
        Iterator edgeIt = geomGraph.getEdgeIterator();
        while (edgeIt.hasNext()) {
            Edge e = (Edge)edgeIt.next();
            int eLoc = e.getLabel().getLocation(argIndex);
            Iterator eiIt = e.getEdgeIntersectionList().iterator();
            while (eiIt.hasNext()) {
                EdgeIntersection ei = (EdgeIntersection)eiIt.next();
                RelateNode n = (RelateNode)this.nodes.addNode(ei.coord);
                if (eLoc == 1) {
                    n.setLabelBoundary(argIndex);
                    continue;
                }
                if (!n.getLabel().isNull(argIndex)) continue;
                n.setLabel(argIndex, 0);
            }
        }
    }

    public void copyNodesAndLabels(GeometryGraph geomGraph, int argIndex) {
        Iterator nodeIt = geomGraph.getNodeIterator();
        while (nodeIt.hasNext()) {
            Node graphNode = (Node)nodeIt.next();
            Node newNode = this.nodes.addNode(graphNode.getCoordinate());
            newNode.setLabel(argIndex, graphNode.getLabel().getLocation(argIndex));
        }
    }

    public void insertEdgeEnds(List ee) {
        for (EdgeEnd e : ee) {
            this.nodes.add(e);
        }
    }
}

