/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.catalog;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.service.catalog.CreateSchema;
import com.databricks.internal.sdk.service.catalog.DeleteSchemaRequest;
import com.databricks.internal.sdk.service.catalog.GetSchemaRequest;
import com.databricks.internal.sdk.service.catalog.ListSchemasRequest;
import com.databricks.internal.sdk.service.catalog.ListSchemasResponse;
import com.databricks.internal.sdk.service.catalog.SchemaInfo;
import com.databricks.internal.sdk.service.catalog.SchemasImpl;
import com.databricks.internal.sdk.service.catalog.SchemasService;
import com.databricks.internal.sdk.service.catalog.UpdateSchema;
import com.databricks.internal.sdk.support.Generated;
import com.databricks.internal.sdk.support.Paginator;
import com.databricks.internal.slf4j.Logger;
import com.databricks.internal.slf4j.LoggerFactory;

@Generated
public class SchemasAPI {
    private static final Logger LOG = LoggerFactory.getLogger(SchemasAPI.class);
    private final SchemasService impl;

    public SchemasAPI(ApiClient apiClient) {
        this.impl = new SchemasImpl(apiClient);
    }

    public SchemasAPI(SchemasService mock) {
        this.impl = mock;
    }

    public SchemaInfo create(CreateSchema request) {
        return this.impl.create(request);
    }

    public void delete(String fullName) {
        this.delete(new DeleteSchemaRequest().setFullName(fullName));
    }

    public void delete(DeleteSchemaRequest request) {
        this.impl.delete(request);
    }

    public SchemaInfo get(String fullName) {
        return this.get(new GetSchemaRequest().setFullName(fullName));
    }

    public SchemaInfo get(GetSchemaRequest request) {
        return this.impl.get(request);
    }

    public Iterable<SchemaInfo> list(String catalogName) {
        return this.list(new ListSchemasRequest().setCatalogName(catalogName));
    }

    public Iterable<SchemaInfo> list(ListSchemasRequest request) {
        return new Paginator(request, this.impl::list, ListSchemasResponse::getSchemas, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public SchemaInfo update(UpdateSchema request) {
        return this.impl.update(request);
    }

    public SchemasService impl() {
        return this.impl;
    }
}

