/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.cleanrooms;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.http.Request;
import com.databricks.internal.sdk.service.cleanrooms.CleanRoomAsset;
import com.databricks.internal.sdk.service.cleanrooms.CleanRoomAssetsService;
import com.databricks.internal.sdk.service.cleanrooms.CreateCleanRoomAssetRequest;
import com.databricks.internal.sdk.service.cleanrooms.CreateCleanRoomAssetReviewRequest;
import com.databricks.internal.sdk.service.cleanrooms.CreateCleanRoomAssetReviewResponse;
import com.databricks.internal.sdk.service.cleanrooms.DeleteCleanRoomAssetRequest;
import com.databricks.internal.sdk.service.cleanrooms.GetCleanRoomAssetRequest;
import com.databricks.internal.sdk.service.cleanrooms.ListCleanRoomAssetsRequest;
import com.databricks.internal.sdk.service.cleanrooms.ListCleanRoomAssetsResponse;
import com.databricks.internal.sdk.service.cleanrooms.UpdateCleanRoomAssetRequest;
import com.databricks.internal.sdk.support.Generated;
import java.io.IOException;

@Generated
class CleanRoomAssetsImpl
implements CleanRoomAssetsService {
    private final ApiClient apiClient;

    public CleanRoomAssetsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public CleanRoomAsset create(CreateCleanRoomAssetRequest request) {
        String path = String.format("/api/2.0/clean-rooms/%s/assets", request.getCleanRoomName());
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request.getAsset()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, CleanRoomAsset.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public CreateCleanRoomAssetReviewResponse createCleanRoomAssetReview(CreateCleanRoomAssetReviewRequest request) {
        String path = String.format("/api/2.0/clean-rooms/%s/assets/%s/%s/reviews", new Object[]{request.getCleanRoomName(), request.getAssetType(), request.getName()});
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, CreateCleanRoomAssetReviewResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeleteCleanRoomAssetRequest request) {
        String path = String.format("/api/2.0/clean-rooms/%s/assets/%s/%s", new Object[]{request.getCleanRoomName(), request.getAssetType(), request.getName()});
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public CleanRoomAsset get(GetCleanRoomAssetRequest request) {
        String path = String.format("/api/2.0/clean-rooms/%s/assets/%s/%s", new Object[]{request.getCleanRoomName(), request.getAssetType(), request.getName()});
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, CleanRoomAsset.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListCleanRoomAssetsResponse list(ListCleanRoomAssetsRequest request) {
        String path = String.format("/api/2.0/clean-rooms/%s/assets", request.getCleanRoomName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListCleanRoomAssetsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public CleanRoomAsset update(UpdateCleanRoomAssetRequest request) {
        String path = String.format("/api/2.0/clean-rooms/%s/assets/%s/%s", new Object[]{request.getCleanRoomName(), request.getAssetType(), request.getName()});
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request.getAsset()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, CleanRoomAsset.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

