/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.iam;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.http.Request;
import com.databricks.internal.sdk.service.iam.GetPermissionLevelsRequest;
import com.databricks.internal.sdk.service.iam.GetPermissionLevelsResponse;
import com.databricks.internal.sdk.service.iam.GetPermissionRequest;
import com.databricks.internal.sdk.service.iam.ObjectPermissions;
import com.databricks.internal.sdk.service.iam.PermissionsService;
import com.databricks.internal.sdk.service.iam.SetObjectPermissions;
import com.databricks.internal.sdk.service.iam.UpdateObjectPermissions;
import com.databricks.internal.sdk.support.Generated;
import java.io.IOException;

@Generated
class PermissionsImpl
implements PermissionsService {
    private final ApiClient apiClient;

    public PermissionsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public ObjectPermissions get(GetPermissionRequest request) {
        String path = String.format("/api/2.0/permissions/%s/%s", request.getRequestObjectType(), request.getRequestObjectId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ObjectPermissions.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public GetPermissionLevelsResponse getPermissionLevels(GetPermissionLevelsRequest request) {
        String path = String.format("/api/2.0/permissions/%s/%s/permissionLevels", request.getRequestObjectType(), request.getRequestObjectId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, GetPermissionLevelsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ObjectPermissions set(SetObjectPermissions request) {
        String path = String.format("/api/2.0/permissions/%s/%s", request.getRequestObjectType(), request.getRequestObjectId());
        try {
            Request req = new Request("PUT", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, ObjectPermissions.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ObjectPermissions update(UpdateObjectPermissions request) {
        String path = String.format("/api/2.0/permissions/%s/%s", request.getRequestObjectType(), request.getRequestObjectId());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, ObjectPermissions.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

