/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.api.impl;

import com.databricks.jdbc.api.impl.DatabricksMap;
import com.databricks.jdbc.api.impl.DatabricksStruct;
import com.databricks.jdbc.api.impl.MetadataParser;
import com.databricks.jdbc.common.util.DatabricksTypeUtil;
import com.databricks.jdbc.exception.DatabricksDriverException;
import com.databricks.jdbc.exception.DatabricksSQLFeatureNotSupportedException;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import com.databricks.jdbc.model.telemetry.enums.DatabricksDriverErrorCode;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class DatabricksArray
implements Array {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(DatabricksArray.class);
    private final Object[] elements;
    private final String typeName;

    public DatabricksArray(List<Object> elements, String metadata) {
        LOGGER.debug("Initializing DatabricksArray with metadata: {}", metadata);
        String elementType = MetadataParser.parseArrayMetadata(metadata);
        this.elements = this.convertElements(elements, elementType);
        this.typeName = metadata;
    }

    private Object[] convertElements(List<Object> elements, String elementType) {
        LOGGER.debug("Converting elements with element type: {}", elementType);
        Object[] convertedElements = new Object[elements.size()];
        for (int i = 0; i < elements.size(); ++i) {
            Object element = elements.get(i);
            try {
                if (elementType.startsWith("STRUCT")) {
                    if (element instanceof Map) {
                        convertedElements[i] = new DatabricksStruct((Map)element, elementType);
                        continue;
                    }
                    if (element instanceof DatabricksStruct) {
                        convertedElements[i] = element;
                        continue;
                    }
                    throw new DatabricksDriverException("Expected a Map for STRUCT but found: " + element.getClass().getSimpleName(), DatabricksDriverErrorCode.COMPLEX_DATA_TYPE_ARRAY_CONVERSION_ERROR);
                }
                if (elementType.startsWith("ARRAY")) {
                    if (element instanceof List) {
                        convertedElements[i] = new DatabricksArray((List)element, elementType);
                        continue;
                    }
                    if (element instanceof DatabricksArray) {
                        convertedElements[i] = element;
                        continue;
                    }
                    throw new DatabricksDriverException("Expected a List for ARRAY but found: " + element.getClass().getSimpleName(), DatabricksDriverErrorCode.COMPLEX_DATA_TYPE_ARRAY_CONVERSION_ERROR);
                }
                if (elementType.startsWith("MAP")) {
                    if (element instanceof Map) {
                        convertedElements[i] = new DatabricksMap((Map)element, elementType);
                        continue;
                    }
                    if (element instanceof DatabricksMap) {
                        convertedElements[i] = element;
                        continue;
                    }
                    throw new DatabricksDriverException("Expected a Map for MAP but found: " + element.getClass().getSimpleName(), DatabricksDriverErrorCode.COMPLEX_DATA_TYPE_ARRAY_CONVERSION_ERROR);
                }
                convertedElements[i] = this.convertValue(element, elementType);
                continue;
            }
            catch (Exception e) {
                String errorMessage = String.format("Error converting element at index %s: %s", i, e.getMessage());
                LOGGER.error(e, errorMessage);
                throw new DatabricksDriverException("Error converting elements", (Throwable)e, DatabricksDriverErrorCode.COMPLEX_DATA_TYPE_ARRAY_CONVERSION_ERROR);
            }
        }
        return convertedElements;
    }

    private Object convertValue(Object value, String type) {
        LOGGER.trace("Converting simple value of type: {}", type);
        if (value == null) {
            return null;
        }
        try {
            switch (type.toUpperCase()) {
                case "INT": {
                    return Integer.parseInt(value.toString());
                }
                case "BIGINT": {
                    return Long.parseLong(value.toString());
                }
                case "SMALLINT": {
                    return Short.parseShort(value.toString());
                }
                case "FLOAT": {
                    return Float.valueOf(Float.parseFloat(value.toString()));
                }
                case "DOUBLE": {
                    return Double.parseDouble(value.toString());
                }
                case "DECIMAL": {
                    return new BigDecimal(value.toString());
                }
                case "BOOLEAN": {
                    return Boolean.parseBoolean(value.toString());
                }
                case "DATE": {
                    return Date.valueOf(value.toString());
                }
                case "TIMESTAMP": {
                    return Timestamp.valueOf(value.toString());
                }
                case "TIME": {
                    return Time.valueOf(value.toString());
                }
                case "BINARY": {
                    return value instanceof byte[] ? value : (Object)value.toString().getBytes();
                }
            }
            return value.toString();
        }
        catch (Exception e) {
            String errorMessage = String.format("Error converting simple value of type %s: %s", type, e.getMessage());
            LOGGER.error(e, errorMessage);
            throw new DatabricksDriverException(errorMessage, DatabricksDriverErrorCode.COMPLEX_DATA_TYPE_ARRAY_CONVERSION_ERROR);
        }
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        LOGGER.debug("Getting base type name");
        return this.typeName;
    }

    @Override
    public int getBaseType() throws SQLException {
        LOGGER.debug("Getting base type");
        return 1111;
    }

    @Override
    public Object getArray() throws SQLException {
        LOGGER.debug("Getting array elements");
        return this.elements;
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        LOGGER.debug("Getting array with type map");
        return this.getArray();
    }

    @Override
    public Object getArray(long index, int count) throws SQLException {
        LOGGER.debug("Getting subarray from index {} with count {}", index, count);
        return Arrays.copyOfRange(this.elements, (int)index - 1, (int)index - 1 + count);
    }

    @Override
    public Object getArray(long index, int count, Map<String, Class<?>> map) throws SQLException {
        LOGGER.debug("Getting subarray with type map from index {} with count {}", index, count);
        return this.getArray(index, count);
    }

    @Override
    public void free() throws SQLException {
        LOGGER.debug("Freeing resources (if any)");
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        LOGGER.error("getResultSet() not implemented");
        throw new DatabricksSQLFeatureNotSupportedException("getResultSet() not implemented");
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        LOGGER.error("getResultSet(Map<String, Class<?>> map) not implemented");
        throw new DatabricksSQLFeatureNotSupportedException("getResultSet(Map<String, Class<?>> map) not implemented");
    }

    @Override
    public ResultSet getResultSet(long index, int count) throws SQLException {
        LOGGER.error("getResultSet(long index, int count) not implemented");
        throw new DatabricksSQLFeatureNotSupportedException("getResultSet(long index, int count) not implemented");
    }

    @Override
    public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) throws SQLException {
        LOGGER.error("getResultSet(long index, int count, Map<String, Class<?>> map) not implemented");
        throw new DatabricksSQLFeatureNotSupportedException("getResultSet(long index, int count, Map<String, Class<?>> map) not implemented");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[");
        for (int i = 0; i < this.elements.length; ++i) {
            Object element;
            if (i > 0) {
                sb.append(",");
            }
            if ((element = this.elements[i]) == null) {
                sb.append("null");
                continue;
            }
            if (element instanceof String || DatabricksTypeUtil.isTemporalType(element)) {
                sb.append("\"").append(element.toString()).append("\"");
                continue;
            }
            sb.append(element.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

