/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.api.impl;

import com.databricks.internal.apache.http.entity.InputStreamEntity;
import com.databricks.internal.google.common.annotations.VisibleForTesting;
import com.databricks.internal.google.common.util.concurrent.MoreExecutors;
import com.databricks.internal.sdk.support.ToStringer;
import com.databricks.jdbc.api.IDatabricksResultSet;
import com.databricks.jdbc.api.IDatabricksStatement;
import com.databricks.jdbc.api.impl.DatabricksConnection;
import com.databricks.jdbc.api.impl.DatabricksResultSet;
import com.databricks.jdbc.api.impl.EmptyResultSet;
import com.databricks.jdbc.api.impl.ImmutableSqlParameter;
import com.databricks.jdbc.api.impl.batch.DatabricksBatchExecutor;
import com.databricks.jdbc.api.internal.IDatabricksStatementInternal;
import com.databricks.jdbc.common.DatabricksJdbcConstants;
import com.databricks.jdbc.common.StatementType;
import com.databricks.jdbc.common.util.DatabricksThreadContextHolder;
import com.databricks.jdbc.common.util.StringUtil;
import com.databricks.jdbc.common.util.ValidationUtil;
import com.databricks.jdbc.common.util.WarningUtil;
import com.databricks.jdbc.dbclient.IDatabricksClient;
import com.databricks.jdbc.dbclient.impl.common.StatementId;
import com.databricks.jdbc.exception.DatabricksDriverException;
import com.databricks.jdbc.exception.DatabricksSQLException;
import com.databricks.jdbc.exception.DatabricksSQLFeatureNotSupportedException;
import com.databricks.jdbc.exception.DatabricksTimeoutException;
import com.databricks.jdbc.exception.DatabricksValidationException;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import com.databricks.jdbc.model.telemetry.enums.DatabricksDriverErrorCode;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class DatabricksStatement
implements IDatabricksStatement,
IDatabricksStatementInternal {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(DatabricksStatement.class);
    private final ExecutorService executor = MoreExecutors.newDirectExecutorService();
    private int timeoutInSeconds;
    protected final DatabricksConnection connection;
    DatabricksResultSet resultSet;
    private StatementId statementId;
    private boolean isClosed;
    private boolean closeOnCompletion;
    private SQLWarning warnings = null;
    private long maxRows = 0L;
    private int maxFieldSize = 0;
    private boolean escapeProcessing = false;
    private InputStreamEntity inputStream = null;
    private boolean allowInputStreamForUCVolume = false;
    private final DatabricksBatchExecutor databricksBatchExecutor;
    private boolean noMoreResults = false;

    public DatabricksStatement(DatabricksConnection connection) throws DatabricksValidationException {
        this.connection = connection;
        this.resultSet = null;
        this.statementId = null;
        this.isClosed = false;
        this.timeoutInSeconds = 0;
        this.databricksBatchExecutor = new DatabricksBatchExecutor(this, connection.getConnectionContext().getMaxBatchSize());
    }

    public DatabricksStatement(DatabricksConnection connection, StatementId statementId) throws DatabricksValidationException {
        this.connection = connection;
        this.statementId = statementId;
        this.resultSet = null;
        this.isClosed = false;
        this.timeoutInSeconds = 0;
        this.databricksBatchExecutor = new DatabricksBatchExecutor(this, connection.getConnectionContext().getMaxBatchSize());
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.checkIfClosed();
        DatabricksResultSet rs = this.executeInternal(sql, new HashMap<Integer, ImmutableSqlParameter>(), StatementType.QUERY);
        if (!DatabricksStatement.shouldReturnResultSet(sql)) {
            String errorMessage = "A ResultSet was expected but not generated from query. However, query execution was successful.";
            throw new DatabricksSQLException(errorMessage, DatabricksDriverErrorCode.RESULT_SET_ERROR);
        }
        return rs;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.checkIfClosed();
        this.executeInternal(sql, new HashMap<Integer, ImmutableSqlParameter>(), StatementType.UPDATE);
        return (int)this.resultSet.getUpdateCount();
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        LOGGER.debug("public long executeLargeUpdate(String sql = {})", sql);
        this.checkIfClosed();
        this.executeInternal(sql, new HashMap<Integer, ImmutableSqlParameter>(), StatementType.UPDATE);
        return this.resultSet.getUpdateCount();
    }

    @Override
    public void close() throws SQLException {
        LOGGER.debug("public void close()");
        this.close(true);
    }

    @Override
    public void close(boolean removeFromSession) throws DatabricksSQLException {
        LOGGER.debug("public void close(boolean removeFromSession)");
        if (this.statementId == null) {
            String warningMsg = "The statement you are trying to close does not have an ID yet.";
            LOGGER.warn(warningMsg);
            this.warnings = WarningUtil.addWarning(this.warnings, warningMsg);
        } else {
            this.connection.getSession().getDatabricksClient().closeStatement(this.statementId);
            if (this.resultSet != null) {
                this.resultSet.close();
                this.resultSet = null;
            }
            if (removeFromSession) {
                this.connection.closeStatement(this);
            }
            DatabricksThreadContextHolder.clearStatementInfo();
        }
        this.shutDownExecutor();
        this.isClosed = true;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        LOGGER.debug("public int getMaxFieldSize()");
        return this.maxFieldSize;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        LOGGER.debug(String.format("public void setMaxFieldSize(int max = {%s})", max));
        this.maxFieldSize = max;
    }

    @Override
    public int getMaxRows() throws DatabricksSQLException {
        LOGGER.debug("public int getMaxRows()");
        this.checkIfClosed();
        return (int)this.maxRows;
    }

    @Override
    public long getLargeMaxRows() throws DatabricksSQLException {
        LOGGER.debug("public void getLargeMaxRows()");
        this.checkIfClosed();
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        LOGGER.debug(String.format("public void setMaxRows(int max = {%s})", max));
        this.checkIfClosed();
        ValidationUtil.checkIfNonNegative(max, "maxRows");
        this.maxRows = max;
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        LOGGER.debug("public void setLargeMaxRows(long max = {})", max);
        this.checkIfClosed();
        ValidationUtil.checkIfNonNegative(max, "maxRows");
        this.maxRows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        LOGGER.debug(String.format("public void setEscapeProcessing(boolean enable = {%s})", enable));
        this.escapeProcessing = enable;
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        LOGGER.debug("public int getQueryTimeout()");
        this.checkIfClosed();
        return this.timeoutInSeconds;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        LOGGER.debug(String.format("public void setQueryTimeout(int seconds = {%s})", seconds));
        this.checkIfClosed();
        ValidationUtil.checkIfNonNegative(seconds, "queryTimeout");
        this.timeoutInSeconds = seconds;
    }

    @Override
    public void cancel() throws SQLException {
        LOGGER.debug("public void cancel()");
        this.checkIfClosed();
        if (this.statementId != null) {
            this.connection.getSession().getDatabricksClient().cancelStatement(this.statementId);
            DatabricksThreadContextHolder.clearStatementInfo();
        } else {
            this.warnings = WarningUtil.addWarning(this.warnings, "The statement you are trying to cancel does not have an ID yet.");
        }
    }

    @Override
    public SQLWarning getWarnings() {
        LOGGER.debug("public SQLWarning getWarnings()");
        return this.warnings;
    }

    @Override
    public void clearWarnings() {
        LOGGER.debug("public void clearWarnings()");
        this.warnings = null;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        LOGGER.debug(String.format("public void setCursorName(String name = {%s})", name));
        throw new DatabricksSQLFeatureNotSupportedException("Not implemented in DatabricksStatement - setCursorName(String name)");
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.checkIfClosed();
        this.resultSet = this.executeInternal(sql, new HashMap<Integer, ImmutableSqlParameter>(), StatementType.SQL);
        return DatabricksStatement.shouldReturnResultSet(sql);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        LOGGER.debug("public ResultSet getResultSet()");
        this.checkIfClosed();
        return this.resultSet;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        LOGGER.debug("public int getUpdateCount()");
        this.checkIfClosed();
        if (this.noMoreResults || this.resultSet == null) {
            return -1;
        }
        return this.resultSet.hasUpdateCount() ? (int)this.resultSet.getUpdateCount() : -1;
    }

    @Override
    public long getLargeUpdateCount() throws SQLException {
        LOGGER.debug("public long getLargeUpdateCount()");
        this.checkIfClosed();
        return this.resultSet.getUpdateCount();
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        LOGGER.debug("public boolean getMoreResults()");
        this.checkIfClosed();
        if (!this.noMoreResults) {
            this.noMoreResults = true;
            if (this.resultSet != null) {
                try {
                    this.resultSet.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        LOGGER.debug(String.format("public void setFetchDirection(int direction = {%s})", direction));
        this.checkIfClosed();
        if (direction != 1000) {
            throw new DatabricksSQLFeatureNotSupportedException("Not supported: ResultSet.FetchForward");
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        LOGGER.debug("public int getFetchDirection()");
        this.checkIfClosed();
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) {
        LOGGER.debug(String.format("public void setFetchSize(int rows = {%s})", rows));
        String warningString = "As FetchSize is not supported in the Databricks JDBC, ignoring it";
        LOGGER.warn(warningString);
        this.warnings = WarningUtil.addWarning(this.warnings, warningString);
    }

    @Override
    public int getFetchSize() {
        LOGGER.debug("public int getFetchSize()");
        String warningString = "As FetchSize is not supported in the Databricks JDBC, we don't set it in the first place";
        LOGGER.warn(warningString);
        this.warnings = WarningUtil.addWarning(this.warnings, warningString);
        return 0;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        LOGGER.debug("public int getResultSetConcurrency()");
        this.checkIfClosed();
        return 1007;
    }

    @Override
    public int getResultSetType() throws SQLException {
        LOGGER.debug("public int getResultSetType()");
        this.checkIfClosed();
        return 1003;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        LOGGER.debug(String.format("public void addBatch(String sql = {%s})", sql));
        this.checkIfClosed();
        this.databricksBatchExecutor.addCommand(sql);
    }

    @Override
    public void clearBatch() throws SQLException {
        LOGGER.debug("public void clearBatch()");
        this.checkIfClosed();
        this.databricksBatchExecutor.clearCommands();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        LOGGER.debug("public int[] executeBatch()");
        this.checkIfClosed();
        long[] largeUpdateCount = this.executeLargeBatch();
        int[] updateCount = new int[largeUpdateCount.length];
        for (int i = 0; i < largeUpdateCount.length; ++i) {
            updateCount[i] = (int)largeUpdateCount[i];
        }
        return updateCount;
    }

    @Override
    public long[] executeLargeBatch() throws SQLException {
        LOGGER.debug("public long[] executeLargeBatch()");
        this.checkIfClosed();
        return this.databricksBatchExecutor.executeBatch();
    }

    @Override
    public Connection getConnection() throws SQLException {
        LOGGER.debug("public Connection getConnection()");
        return this.connection;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        LOGGER.debug(String.format("public boolean getMoreResults(int current = {%s})", current));
        throw new DatabricksSQLFeatureNotSupportedException("Not implemented in DatabricksStatement - getMoreResults(int current)");
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        LOGGER.debug("public ResultSet getGeneratedKeys()");
        this.checkIfClosed();
        return new EmptyResultSet();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkIfClosed();
        if (autoGeneratedKeys == 2) {
            return this.executeUpdate(sql);
        }
        throw new DatabricksSQLFeatureNotSupportedException("Method not supported: executeUpdate(String sql, int autoGeneratedKeys)");
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        LOGGER.debug("public long executeLargeUpdate(String sql = {}, int autoGeneratedKeys = {})", sql, autoGeneratedKeys);
        this.checkIfClosed();
        if (autoGeneratedKeys == 2) {
            return this.executeLargeUpdate(sql);
        }
        throw new DatabricksSQLFeatureNotSupportedException("Method not supported: executeLargeUpdate(String sql, int autoGeneratedKeys)");
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Method not supported: executeUpdate(String sql, int[] columnIndexes)");
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        LOGGER.debug("public long executeLargeUpdate(String sql = {}, int[] columnIndexes = {})", sql, columnIndexes);
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Method not supported: executeLargeUpdate(String sql, int[] columnIndexes)");
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        LOGGER.debug("public int executeUpdate(String sql, String[] columnNames)");
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Method not supported: executeUpdate(String sql, String[] columnNames)");
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        LOGGER.debug("public long executeLargeUpdate(String sql = {}, String[] columnNames = {})", sql, columnNames);
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Method not supported: executeLargeUpdate(String sql, String[] columnNames)");
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkIfClosed();
        if (autoGeneratedKeys == 2) {
            return this.execute(sql);
        }
        throw new DatabricksSQLFeatureNotSupportedException("Method not supported: execute(String sql, int autoGeneratedKeys)");
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Method not supported: execute(String sql, int[] columnIndexes)");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.checkIfClosed();
        throw new DatabricksSQLFeatureNotSupportedException("Method not supported: execute(String sql, String[] columnNames)");
    }

    @Override
    public int getResultSetHoldability() {
        LOGGER.debug("public int getResultSetHoldability()");
        return 2;
    }

    @Override
    public boolean isClosed() throws SQLException {
        LOGGER.debug("public boolean isClosed()");
        return this.isClosed;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        LOGGER.debug(String.format("public void setPoolable(boolean poolable = {%s})", poolable));
        this.checkIfClosed();
        if (poolable) {
            throw new DatabricksSQLFeatureNotSupportedException("Method not supported: setPoolable(boolean poolable)");
        }
    }

    @Override
    public boolean isPoolable() throws SQLException {
        LOGGER.debug("public boolean isPoolable()");
        this.checkIfClosed();
        return false;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        LOGGER.debug("public void closeOnCompletion()");
        this.checkIfClosed();
        this.closeOnCompletion = true;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        LOGGER.debug("public boolean isCloseOnCompletion()");
        this.checkIfClosed();
        return this.closeOnCompletion;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        LOGGER.debug("public <T> T unwrap(Class<T> iface)");
        if (iface.isInstance(this)) {
            return (T)this;
        }
        throw new DatabricksSQLException(String.format("Class {%s} cannot be wrapped from {%s}", this.getClass().getName(), iface.getName()), DatabricksDriverErrorCode.INPUT_VALIDATION_ERROR);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        LOGGER.debug("public boolean isWrapperFor(Class<?> iface)");
        return iface.isInstance(this);
    }

    @Override
    public void handleResultSetClose(IDatabricksResultSet resultSet) throws DatabricksSQLException {
        if (this.closeOnCompletion) {
            this.close(true);
        }
    }

    @Override
    public void setStatementId(StatementId statementId) {
        LOGGER.debug("void setStatementId(Statement statementId = {})", statementId);
        this.statementId = statementId;
    }

    @Override
    public StatementId getStatementId() {
        return this.statementId;
    }

    @Override
    public Statement getStatement() {
        return this;
    }

    @Override
    public void allowInputStreamForVolumeOperation(boolean allowInputStream) throws DatabricksSQLException {
        this.checkIfClosed();
        this.allowInputStreamForUCVolume = allowInputStream;
    }

    @Override
    public boolean isAllowedInputStreamForVolumeOperation() throws DatabricksSQLException {
        this.checkIfClosed();
        return this.allowInputStreamForUCVolume;
    }

    @Override
    public void setInputStreamForUCVolume(InputStreamEntity inputStream) throws DatabricksSQLException {
        if (!this.isAllowedInputStreamForVolumeOperation()) {
            throw new DatabricksSQLException("Volume operation not supported for Input Stream", DatabricksDriverErrorCode.INPUT_VALIDATION_ERROR);
        }
        this.inputStream = inputStream;
    }

    @Override
    public InputStreamEntity getInputStreamForUCVolume() throws DatabricksSQLException {
        if (this.isAllowedInputStreamForVolumeOperation()) {
            return this.inputStream;
        }
        return null;
    }

    @Override
    public ResultSet executeAsync(String sql) throws SQLException {
        LOGGER.debug("ResultSet executeAsync() for statement {%s}", sql);
        this.checkIfClosed();
        IDatabricksClient client = this.connection.getSession().getDatabricksClient();
        DatabricksThreadContextHolder.setStatementType(StatementType.SQL);
        return client.executeStatementAsync(sql, this.connection.getSession().getComputeResource(), Collections.emptyMap(), this.connection.getSession(), this);
    }

    @Override
    public ResultSet getExecutionResult() throws SQLException {
        LOGGER.debug("ResultSet getExecutionResult() for statementId {%s}", this.statementId);
        this.checkIfClosed();
        if (this.statementId == null) {
            throw new DatabricksSQLException("No execution available for statement", DatabricksDriverErrorCode.INPUT_VALIDATION_ERROR);
        }
        return this.connection.getSession().getDatabricksClient().getStatementResult(this.statementId, this.connection.getSession(), this);
    }

    @Override
    public String enquoteLiteral(String val) throws SQLException {
        LOGGER.debug("String enquoteLiteral(String val = {})", val);
        this.checkIfClosed();
        return IDatabricksStatement.super.enquoteLiteral(val);
    }

    @Override
    public String enquoteIdentifier(String identifier, boolean alwaysQuote) throws DatabricksSQLException {
        LOGGER.debug("String enquoteIdentifier(String identifier = {}, boolean alwaysQuote = {})", identifier, alwaysQuote);
        this.checkIfClosed();
        try {
            return IDatabricksStatement.super.enquoteIdentifier(identifier, alwaysQuote);
        }
        catch (SQLException e) {
            throw new DatabricksSQLException(e.getMessage(), DatabricksDriverErrorCode.INPUT_VALIDATION_ERROR);
        }
    }

    @Override
    public String enquoteNCharLiteral(String val) throws SQLException {
        LOGGER.debug("String enquoteNCharLiteral(String val = {})", val);
        this.checkIfClosed();
        return IDatabricksStatement.super.enquoteNCharLiteral(val);
    }

    @Override
    public boolean isSimpleIdentifier(String identifier) throws SQLException {
        LOGGER.debug("String isSimpleIdentifier(String identifier = {})", identifier);
        this.checkIfClosed();
        return IDatabricksStatement.super.isSimpleIdentifier(identifier);
    }

    static String trimCommentsAndWhitespaces(String query) {
        if (query == null || query.trim().isEmpty()) {
            throw new DatabricksDriverException("Query cannot be null or empty", DatabricksDriverErrorCode.INPUT_VALIDATION_ERROR);
        }
        String trimmedQuery = query.trim().replaceAll("(?m)--.*$", "");
        trimmedQuery = trimmedQuery.replaceAll("/\\*.*?\\*/", "");
        trimmedQuery = trimmedQuery.replaceAll("\\s+", " ").trim();
        return trimmedQuery;
    }

    @VisibleForTesting
    static boolean shouldReturnResultSet(String query) {
        String trimmedQuery = DatabricksStatement.trimCommentsAndWhitespaces(query);
        return DatabricksJdbcConstants.SELECT_PATTERN.matcher(trimmedQuery).find() || DatabricksJdbcConstants.SHOW_PATTERN.matcher(trimmedQuery).find() || DatabricksJdbcConstants.DESCRIBE_PATTERN.matcher(trimmedQuery).find() || DatabricksJdbcConstants.EXPLAIN_PATTERN.matcher(trimmedQuery).find() || DatabricksJdbcConstants.WITH_PATTERN.matcher(trimmedQuery).find() || DatabricksJdbcConstants.SET_PATTERN.matcher(trimmedQuery).find() || DatabricksJdbcConstants.MAP_PATTERN.matcher(trimmedQuery).find() || DatabricksJdbcConstants.FROM_PATTERN.matcher(trimmedQuery).find() || DatabricksJdbcConstants.VALUES_PATTERN.matcher(trimmedQuery).find() || DatabricksJdbcConstants.UNION_PATTERN.matcher(trimmedQuery).find() || DatabricksJdbcConstants.INTERSECT_PATTERN.matcher(trimmedQuery).find() || DatabricksJdbcConstants.EXCEPT_PATTERN.matcher(trimmedQuery).find() || DatabricksJdbcConstants.DECLARE_PATTERN.matcher(trimmedQuery).find() || DatabricksJdbcConstants.PUT_PATTERN.matcher(trimmedQuery).find() || DatabricksJdbcConstants.GET_PATTERN.matcher(trimmedQuery).find() || DatabricksJdbcConstants.REMOVE_PATTERN.matcher(trimmedQuery).find() || DatabricksJdbcConstants.LIST_PATTERN.matcher(trimmedQuery).find() || DatabricksJdbcConstants.BEGIN_PATTERN_FOR_SQL_SCRIPT.matcher(trimmedQuery).find() || DatabricksJdbcConstants.CALL_PATTERN.matcher(trimmedQuery).find();
    }

    static boolean isSelectQuery(String query) {
        String trimmedQuery = DatabricksStatement.trimCommentsAndWhitespaces(query);
        return DatabricksJdbcConstants.SELECT_PATTERN.matcher(trimmedQuery).find();
    }

    static boolean isInsertQuery(String query) {
        if (query == null || query.trim().isEmpty()) {
            return false;
        }
        String trimmedQuery = DatabricksStatement.trimCommentsAndWhitespaces(query);
        return DatabricksJdbcConstants.INSERT_PATTERN.matcher(trimmedQuery).find();
    }

    DatabricksResultSet executeInternal(String sql, Map<Integer, ImmutableSqlParameter> params, StatementType statementType, boolean closeStatement) throws SQLException {
        String stackTraceMessage = String.format("DatabricksResultSet executeInternal(String sql = %s, Map<Integer, ImmutableSqlParameter> params = {%s}, StatementType statementType = {%s})", new Object[]{sql, params, statementType});
        LOGGER.debug(stackTraceMessage);
        CompletableFuture<DatabricksResultSet> futureResultSet = this.getFutureResult(sql, params, statementType);
        try {
            this.resultSet = this.timeoutInSeconds == 0 ? futureResultSet.get() : futureResultSet.get(this.timeoutInSeconds, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            if (closeStatement) {
                try {
                    this.close();
                }
                catch (SQLException sqlExceptionForClose) {
                    LOGGER.error(sqlExceptionForClose, String.format("Error occurred while closing statement after timeout. StatementId %s", this.statementId));
                }
            }
            String timeoutErrorMessage = String.format("Statement execution timed-out. ErrorMessage %s, statementId %s", stackTraceMessage, this.statementId);
            LOGGER.error(timeoutErrorMessage);
            futureResultSet.cancel(true);
            throw new DatabricksTimeoutException(timeoutErrorMessage, e, DatabricksDriverErrorCode.STATEMENT_EXECUTION_TIMEOUT);
        }
        catch (InterruptedException | ExecutionException e) {
            Throwable cause = e;
            while (cause.getCause() != null) {
                if (!((cause = cause.getCause()) instanceof DatabricksSQLException)) continue;
                throw (DatabricksSQLException)cause;
            }
            String errMsg = String.format("Error occurred during statement execution: %s. Error : %s", sql, e.getMessage());
            LOGGER.error(e, errMsg);
            throw new DatabricksSQLException(errMsg, (Throwable)e, DatabricksDriverErrorCode.EXECUTE_STATEMENT_FAILED);
        }
        LOGGER.debug("Result retrieved successfully {}", this.resultSet.toString());
        return this.resultSet;
    }

    DatabricksResultSet executeInternal(String sql, Map<Integer, ImmutableSqlParameter> params, StatementType statementType) throws SQLException {
        this.noMoreResults = false;
        DatabricksThreadContextHolder.setStatementType(statementType);
        return this.executeInternal(sql, params, statementType, true);
    }

    CompletableFuture<DatabricksResultSet> getFutureResult(String sql, Map<Integer, ImmutableSqlParameter> params, StatementType statementType) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                String SQLString = this.escapeProcessing ? StringUtil.convertJdbcEscapeSequences(sql) : sql;
                SQLString = StringUtil.removeRedundantEscapeClause(SQLString);
                return this.getResultFromClient(SQLString, params, statementType);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }, this.executor);
    }

    DatabricksResultSet getResultFromClient(String sql, Map<Integer, ImmutableSqlParameter> params, StatementType statementType) throws SQLException {
        IDatabricksClient client = this.connection.getSession().getDatabricksClient();
        return client.executeStatement(sql, this.connection.getSession().getComputeResource(), params, statementType, this.connection.getSession(), this);
    }

    void checkIfClosed() throws DatabricksSQLException {
        if (this.isClosed) {
            throw new DatabricksSQLException("Statement is closed", DatabricksDriverErrorCode.STATEMENT_CLOSED);
        }
    }

    private void shutDownExecutor() {
        this.executor.shutdown();
        try {
            if (!this.executor.awaitTermination(60L, TimeUnit.SECONDS)) {
                this.executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    public String toString() {
        return new ToStringer(DatabricksStatement.class).add("statementId", this.statementId).toString();
    }
}

