/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.api.impl.arrow;

import com.databricks.jdbc.api.impl.arrow.ChunkStatus;
import com.databricks.jdbc.dbclient.impl.common.StatementId;
import com.databricks.jdbc.exception.DatabricksParsingException;
import com.databricks.jdbc.model.telemetry.enums.DatabricksDriverErrorCode;
import java.util.Set;

public class ArrowResultChunkStateMachine {
    private ChunkStatus currentStatus;
    private final long chunkIndex;
    private final StatementId statementId;

    public ArrowResultChunkStateMachine(ChunkStatus initialStatus, long chunkIndex, StatementId statementId) {
        this.currentStatus = initialStatus;
        this.chunkIndex = chunkIndex;
        this.statementId = statementId;
    }

    public synchronized void transition(ChunkStatus targetStatus) throws DatabricksParsingException {
        if (targetStatus == this.currentStatus) {
            return;
        }
        if (!this.currentStatus.canTransitionTo(targetStatus)) {
            throw new DatabricksParsingException(String.format("Invalid state transition for chunk [%d] and statement [%s]: %s -> %s. Valid transitions from %s are: %s", new Object[]{this.chunkIndex, this.statementId, this.currentStatus, targetStatus, this.currentStatus, this.currentStatus.getValidTransitions()}), DatabricksDriverErrorCode.INVALID_CHUNK_STATE_TRANSITION);
        }
        this.currentStatus = targetStatus;
    }

    public synchronized boolean isValidTransition(ChunkStatus targetStatus) {
        return this.currentStatus.canTransitionTo(targetStatus);
    }

    public synchronized Set<ChunkStatus> getValidTargetStates() {
        return this.currentStatus.getValidTransitions();
    }

    public synchronized ChunkStatus getCurrentStatus() {
        return this.currentStatus;
    }
}

