/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.api.impl.arrow;

import com.databricks.jdbc.api.impl.arrow.ChunkLinkFetcher;
import com.databricks.jdbc.api.internal.IDatabricksSession;
import com.databricks.jdbc.dbclient.impl.common.StatementId;
import com.databricks.jdbc.exception.DatabricksSQLException;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import com.databricks.jdbc.model.core.ChunkLinkFetchResult;
import com.databricks.jdbc.model.core.ExternalLink;
import com.databricks.jdbc.model.telemetry.enums.DatabricksDriverErrorCode;

public class SeaChunkLinkFetcher
implements ChunkLinkFetcher {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(SeaChunkLinkFetcher.class);
    private final IDatabricksSession session;
    private final StatementId statementId;

    public SeaChunkLinkFetcher(IDatabricksSession session, StatementId statementId) {
        this.session = session;
        this.statementId = statementId;
        LOGGER.debug("Created SeaChunkLinkFetcher for statement {}", statementId);
    }

    @Override
    public ChunkLinkFetchResult fetchLinks(long startChunkIndex, long startRowOffset) throws DatabricksSQLException {
        LOGGER.debug("Fetching links starting from chunk index {} for statement {}", startChunkIndex, this.statementId);
        return this.session.getDatabricksClient().getResultChunks(this.statementId, startChunkIndex, startRowOffset);
    }

    @Override
    public ExternalLink refetchLink(long chunkIndex, long rowOffset) throws DatabricksSQLException {
        LOGGER.info("Refetching expired link for chunk {} of statement {}", chunkIndex, this.statementId);
        ChunkLinkFetchResult result = this.session.getDatabricksClient().getResultChunks(this.statementId, chunkIndex, rowOffset);
        if (result.isEndOfStream()) {
            throw new DatabricksSQLException(String.format("Failed to refetch link for chunk %d: no links returned", chunkIndex), DatabricksDriverErrorCode.CHUNK_READY_ERROR);
        }
        for (ExternalLink link : result.getChunkLinks()) {
            if (link.getChunkIndex() != chunkIndex) continue;
            LOGGER.debug("Successfully refetched link for chunk {} of statement {}", chunkIndex, this.statementId);
            return link;
        }
        throw new DatabricksSQLException(String.format("Failed to refetch link for chunk %d: server returned links but none matched requested index", chunkIndex), DatabricksDriverErrorCode.CHUNK_READY_ERROR);
    }

    @Override
    public void close() {
        LOGGER.debug("Closing SeaChunkLinkFetcher for statement {}", this.statementId);
    }
}

