/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.common.util;

import com.databricks.internal.apache.commons.io.IOUtils;
import com.databricks.internal.jpountz.lz4.LZ4FrameInputStream;
import com.databricks.jdbc.common.CompressionCodec;
import com.databricks.jdbc.exception.DatabricksParsingException;
import com.databricks.jdbc.exception.DatabricksSQLException;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import com.databricks.jdbc.model.telemetry.enums.DatabricksDriverErrorCode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class DecompressionUtil {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(DecompressionUtil.class);

    private static byte[] decompressLZ4Frame(byte[] compressedInput, String context) throws DatabricksSQLException {
        LOGGER.debug("Decompressing using LZ4 Frame algorithm. Context: {}", context);
        try {
            return IOUtils.toByteArray(new LZ4FrameInputStream(new ByteArrayInputStream(compressedInput)));
        }
        catch (IOException e) {
            String errorMessage = String.format("Unable to de-compress LZ4 Frame compressed result %s", context);
            LOGGER.error(e, errorMessage);
            throw new DatabricksParsingException(errorMessage, (Throwable)e, DatabricksDriverErrorCode.DECOMPRESSION_ERROR);
        }
    }

    public static byte[] decompress(byte[] compressedInput, CompressionCodec compressionCodec, String context) throws DatabricksSQLException {
        if (compressionCodec == null || compressedInput == null) {
            LOGGER.debug("Compression is NONE /InputStream is `NULL`. Skipping compression.");
            return compressedInput;
        }
        switch (compressionCodec) {
            case NONE: {
                LOGGER.debug("Compression type is `NONE`. Skipping compression.");
                return compressedInput;
            }
            case LZ4_FRAME: {
                return DecompressionUtil.decompressLZ4Frame(compressedInput, context);
            }
        }
        String errorMessage = String.format("Unknown compression type: %s. Context : %s", new Object[]{compressionCodec, context});
        LOGGER.error(errorMessage);
        throw new DatabricksSQLException(errorMessage, DatabricksDriverErrorCode.DECOMPRESSION_ERROR);
    }

    public static InputStream decompressToStream(byte[] compressedInput, CompressionCodec compressionCodec, String context) throws DatabricksSQLException {
        byte[] uncompressed = DecompressionUtil.decompress(compressedInput, compressionCodec, context);
        return new ByteArrayInputStream(uncompressed);
    }

    public static InputStream decompress(InputStream compressedStream, CompressionCodec compressionCodec, String context) throws IOException, DatabricksSQLException {
        if (compressionCodec == null || compressionCodec.equals((Object)CompressionCodec.NONE) || compressedStream == null) {
            LOGGER.debug("Compression is NONE /InputStream is `NULL`. Skipping compression.");
            return compressedStream;
        }
        byte[] compressedBytes = IOUtils.toByteArray(compressedStream);
        byte[] uncompressedBytes = DecompressionUtil.decompress(compressedBytes, compressionCodec, context);
        return new ByteArrayInputStream(uncompressedBytes);
    }
}

