/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.common.util;

import com.databricks.internal.apache.http.HttpResponse;
import com.databricks.internal.apache.http.util.EntityUtils;
import com.databricks.internal.fasterxml.jackson.databind.JsonNode;
import com.databricks.jdbc.common.DatabricksJdbcConstants;
import com.databricks.jdbc.common.DatabricksJdbcUrlParams;
import com.databricks.jdbc.common.util.JsonUtil;
import com.databricks.jdbc.exception.DatabricksHttpException;
import com.databricks.jdbc.exception.DatabricksValidationException;
import com.databricks.jdbc.exception.DatabricksVendorCode;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class ValidationUtil {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(ValidationUtil.class);

    public static <T extends Number> void checkIfNonNegative(T number, String fieldName) throws DatabricksValidationException {
        if (number.longValue() < 0L) {
            String errorMessage = String.format("Invalid input for %s, : %d", fieldName, number.longValue());
            LOGGER.error(errorMessage);
            throw new DatabricksValidationException(errorMessage);
        }
    }

    public static <T extends Number> void checkIfPositive(T number, String fieldName) throws DatabricksValidationException {
        if (number.longValue() <= 0L) {
            String errorMessage = String.format("Invalid value for %s: %d. Value must be a positive integer (> 0).", fieldName, number.longValue());
            LOGGER.error(errorMessage);
            throw new DatabricksValidationException(errorMessage);
        }
    }

    public static int validateAndParsePositiveInteger(String value, String fieldName) throws DatabricksValidationException {
        try {
            int parsedValue = Integer.parseInt(value);
            ValidationUtil.checkIfPositive(parsedValue, fieldName);
            return parsedValue;
        }
        catch (NumberFormatException e) {
            String errorMessage = String.format("Invalid value for %s: '%s'. Value must be a valid positive integer.", fieldName, value);
            LOGGER.error(errorMessage);
            throw new DatabricksValidationException(errorMessage);
        }
    }

    public static void throwErrorIfNull(Map<String, String> fields, String context) throws DatabricksValidationException {
        for (Map.Entry<String, String> field : fields.entrySet()) {
            if (field.getValue() != null) continue;
            String errorMessage = String.format("Unsupported null Input for field {%s}. Context: {%s}", field.getKey(), context);
            LOGGER.error(errorMessage);
            throw new DatabricksValidationException(errorMessage);
        }
    }

    public static void throwErrorIfNull(String field, Object value) throws DatabricksValidationException {
        if (value != null) {
            return;
        }
        String errorMessage = String.format("Unsupported null Input for field {%s}", field);
        LOGGER.error(errorMessage);
        throw new DatabricksValidationException(errorMessage);
    }

    public static void checkHTTPError(HttpResponse response) throws DatabricksHttpException, IOException {
        int statusCode = response.getStatusLine().getStatusCode();
        String statusLine = response.getStatusLine().toString();
        if (statusCode >= 200 && statusCode < 300) {
            return;
        }
        Object errorReason = String.format("HTTP request failed by code: %d, status line: %s.", statusCode, statusLine);
        if (response.containsHeader("X-Thriftserver-Error-Message")) {
            errorReason = (String)errorReason + String.format(" Thrift Header : %s", response.getFirstHeader("X-Thriftserver-Error-Message").getValue());
        }
        if (response.getEntity() != null) {
            try {
                JsonNode jsonNode = JsonUtil.getMapper().readTree(EntityUtils.toString(response.getEntity()));
                JsonNode errorNode = jsonNode.path("message");
                if (errorNode.isTextual()) {
                    errorReason = (String)errorReason + String.format(" Error message: %s", errorNode.textValue());
                }
            }
            catch (Exception e) {
                LOGGER.warn("Unable to parse JSON from response entity", e);
            }
        }
        LOGGER.error((String)errorReason);
        throw new DatabricksHttpException((String)errorReason, "08000");
    }

    public static boolean isValidJdbcUrl(String url) {
        List<Pattern> PATH_PATTERNS = List.of(DatabricksJdbcConstants.HTTP_CLUSTER_PATH_PATTERN, DatabricksJdbcConstants.HTTP_WAREHOUSE_PATH_PATTERN, DatabricksJdbcConstants.HTTP_ENDPOINT_PATH_PATTERN, DatabricksJdbcConstants.TEST_PATH_PATTERN, DatabricksJdbcConstants.BASE_PATTERN, DatabricksJdbcConstants.HTTP_CLI_PATTERN);
        if (!DatabricksJdbcConstants.JDBC_URL_PATTERN.matcher(url).matches()) {
            return false;
        }
        return PATH_PATTERNS.stream().anyMatch(pattern -> pattern.matcher(url).matches());
    }

    public static void validateInputProperties(Map<String, String> parameters) throws DatabricksValidationException {
        ValidationUtil.validateUidParameter(parameters);
    }

    public static void validateUidParameter(Map<String, String> parameters) throws DatabricksValidationException {
        String uid = parameters.get(DatabricksJdbcUrlParams.UID.getParamName());
        if (uid != null && !uid.equals("token")) {
            LOGGER.error(DatabricksVendorCode.INCORRECT_UID.getMessage());
            throw new DatabricksValidationException(DatabricksVendorCode.INCORRECT_UID.getMessage(), DatabricksVendorCode.INCORRECT_UID.getCode());
        }
    }
}

