/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.jdbc.dbclient.impl.thrift;

import com.databricks.internal.apache.http.HttpEntity;
import com.databricks.internal.apache.http.client.methods.CloseableHttpResponse;
import com.databricks.internal.apache.http.client.methods.HttpPost;
import com.databricks.internal.apache.http.entity.ByteArrayEntity;
import com.databricks.internal.apache.http.util.EntityUtils;
import com.databricks.internal.apache.thrift.TConfiguration;
import com.databricks.internal.apache.thrift.transport.TTransport;
import com.databricks.internal.apache.thrift.transport.TTransportException;
import com.databricks.internal.google.common.annotations.VisibleForTesting;
import com.databricks.internal.sdk.core.DatabricksConfig;
import com.databricks.jdbc.api.internal.IDatabricksConnectionContext;
import com.databricks.jdbc.common.util.ValidationUtil;
import com.databricks.jdbc.dbclient.IDatabricksHttpClient;
import com.databricks.jdbc.dbclient.impl.common.TracingUtil;
import com.databricks.jdbc.exception.DatabricksHttpException;
import com.databricks.jdbc.log.JdbcLogger;
import com.databricks.jdbc.log.JdbcLoggerFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DatabricksHttpTTransport
extends TTransport {
    private static final JdbcLogger LOGGER = JdbcLoggerFactory.getLogger(DatabricksHttpTTransport.class);
    private static final Map<String, String> DEFAULT_HEADERS = Map.of("Content-Type", "application/x-thrift", "Accept", "application/x-thrift");
    private final IDatabricksHttpClient httpClient;
    private final String url;
    private Map<String, String> customHeaders = Collections.emptyMap();
    private final ByteArrayOutputStream requestBuffer;
    private ByteArrayInputStream responseBuffer;
    private final IDatabricksConnectionContext connectionContext;
    DatabricksConfig databricksConfig;

    public DatabricksHttpTTransport(IDatabricksHttpClient httpClient, String url, DatabricksConfig databricksConfig, IDatabricksConnectionContext connectionContext) {
        this.httpClient = httpClient;
        this.url = url;
        this.requestBuffer = new ByteArrayOutputStream();
        this.responseBuffer = null;
        this.databricksConfig = databricksConfig;
        this.connectionContext = connectionContext;
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void open() throws TTransportException {
    }

    @Override
    public void close() {
    }

    @Override
    public int read(byte[] buf, int off, int len) throws TTransportException {
        if (this.responseBuffer == null) {
            LOGGER.error("Response buffer is empty, no response.");
            throw new TTransportException("Response buffer is empty, no response.");
        }
        int numBytes = this.responseBuffer.read(buf, off, len);
        if (numBytes == -1) {
            LOGGER.error("No data available to read.");
            throw new TTransportException("No more data available.");
        }
        return numBytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] buf, int off, int len) {
        ByteArrayOutputStream byteArrayOutputStream = this.requestBuffer;
        synchronized (byteArrayOutputStream) {
            this.requestBuffer.write(buf, off, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws TTransportException {
        byte[] requestPayload;
        long refreshHeadersStartTime = System.currentTimeMillis();
        this.refreshHeadersIfRequired();
        long refreshHeadersEndTime = System.currentTimeMillis();
        long refreshHeadersLatency = refreshHeadersEndTime - refreshHeadersStartTime;
        LOGGER.trace("Connection [" + this.connectionContext.getConnectionUuid() + "] Header refresh latency: " + refreshHeadersLatency + "ms");
        HttpPost request = new HttpPost(this.url);
        DEFAULT_HEADERS.forEach(request::addHeader);
        this.customHeaders.forEach(request::addHeader);
        this.connectionContext.getCustomHeaders().forEach(request::setHeader);
        if (this.connectionContext.isRequestTracingEnabled()) {
            String traceHeader = TracingUtil.getTraceHeader();
            LOGGER.debug("Thrift tracing header: " + traceHeader);
            request.addHeader("traceparent", traceHeader);
        }
        ByteArrayOutputStream byteArrayOutputStream = this.requestBuffer;
        synchronized (byteArrayOutputStream) {
            requestPayload = this.requestBuffer.toByteArray();
            this.requestBuffer.reset();
        }
        request.setEntity(new ByteArrayEntity(requestPayload));
        long httpRequestStartTime = System.currentTimeMillis();
        try (CloseableHttpResponse response = this.httpClient.execute(request);){
            ValidationUtil.checkHTTPError(response);
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                byte[] responseBytes = EntityUtils.toByteArray(entity);
                this.responseBuffer = new ByteArrayInputStream(responseBytes);
            }
        }
        catch (DatabricksHttpException | IOException e) {
            long httpRequestEndTime = System.currentTimeMillis();
            long httpRequestLatency = httpRequestEndTime - httpRequestStartTime;
            LOGGER.debug("Connection [" + this.connectionContext.getConnectionUuid() + "] HTTP request latency (with error): " + httpRequestLatency + "ms");
            String errorMessage = "Failed to flush data to server: " + e.getMessage();
            LOGGER.error(e, errorMessage);
            throw new TTransportException(0, errorMessage, e);
        }
    }

    @Override
    public TConfiguration getConfiguration() {
        return null;
    }

    @Override
    public void updateKnownMessageSize(long size) throws TTransportException {
    }

    @Override
    public void checkReadBytesAvailable(long numBytes) throws TTransportException {
    }

    private void refreshHeadersIfRequired() {
        Map<String, String> refreshedHeaders = this.databricksConfig.authenticate();
        this.customHeaders = refreshedHeaders != null ? new HashMap<String, String>(refreshedHeaders) : Collections.emptyMap();
    }

    @VisibleForTesting
    void setResponseBuffer(ByteArrayInputStream responseBuffer) {
        this.responseBuffer = responseBuffer;
    }
}

