/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.awt;

import com.databricks.internal.jts.awt.ShapeReader;
import com.databricks.internal.jts.geom.Geometry;
import com.databricks.internal.jts.geom.GeometryFactory;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.util.ArrayList;

public class FontGlyphReader {
    public static final String FONT_SERIF = "Serif";
    public static final String FONT_SANSERIF = "SansSerif";
    public static final String FONT_SANSSERIF = "SansSerif";
    public static final String FONT_MONOSPACED = "Monospaced";
    private static final double FLATNESS_FACTOR = 400.0;

    private FontGlyphReader() {
    }

    public static Geometry read(String text, String fontName, int pointSize, GeometryFactory geomFact) {
        return FontGlyphReader.read(text, new Font(fontName, 0, pointSize), geomFact);
    }

    public static Geometry read(String text, Font font, GeometryFactory geomFact) {
        double flatness = (double)font.getSize() / 400.0;
        return FontGlyphReader.read(text, font, flatness, geomFact);
    }

    public static Geometry read(String text, Font font, double flatness, GeometryFactory geomFact) {
        char[] chs = text.toCharArray();
        FontRenderContext fontContext = new FontRenderContext(null, false, true);
        GlyphVector gv = font.createGlyphVector(fontContext, chs);
        ArrayList<Geometry> polys = new ArrayList<Geometry>();
        for (int i = 0; i < gv.getNumGlyphs(); ++i) {
            Geometry geom = ShapeReader.read(gv.getGlyphOutline(i), flatness, geomFact);
            for (int j = 0; j < geom.getNumGeometries(); ++j) {
                polys.add(geom.getGeometryN(j));
            }
        }
        return geomFact.buildGeometry(polys);
    }
}

