/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.noding.snapround;

import com.databricks.internal.jts.algorithm.LineIntersector;
import com.databricks.internal.jts.algorithm.RobustLineIntersector;
import com.databricks.internal.jts.geom.Coordinate;
import com.databricks.internal.jts.geom.PrecisionModel;
import com.databricks.internal.jts.noding.InteriorIntersectionFinderAdder;
import com.databricks.internal.jts.noding.MCIndexNoder;
import com.databricks.internal.jts.noding.NodedSegmentString;
import com.databricks.internal.jts.noding.Noder;
import com.databricks.internal.jts.noding.snapround.HotPixel;
import com.databricks.internal.jts.noding.snapround.MCIndexPointSnapper;
import java.util.Collection;
import java.util.List;

@Deprecated
public class MCIndexSnapRounder
implements Noder {
    private final PrecisionModel pm;
    private LineIntersector li;
    private final double scaleFactor;
    private MCIndexNoder noder;
    private MCIndexPointSnapper pointSnapper;
    private Collection nodedSegStrings;

    public MCIndexSnapRounder(PrecisionModel pm) {
        this.pm = pm;
        this.li = new RobustLineIntersector();
        this.li.setPrecisionModel(pm);
        this.scaleFactor = pm.getScale();
    }

    @Override
    public Collection getNodedSubstrings() {
        return NodedSegmentString.getNodedSubstrings(this.nodedSegStrings);
    }

    @Override
    public void computeNodes(Collection inputSegmentStrings) {
        this.nodedSegStrings = inputSegmentStrings;
        this.noder = new MCIndexNoder();
        this.pointSnapper = new MCIndexPointSnapper(this.noder.getIndex());
        this.snapRound(inputSegmentStrings, this.li);
    }

    private void snapRound(Collection segStrings, LineIntersector li) {
        List intersections = this.findInteriorIntersections(segStrings, li);
        this.computeIntersectionSnaps(intersections);
        this.computeVertexSnaps(segStrings);
    }

    private List findInteriorIntersections(Collection segStrings, LineIntersector li) {
        InteriorIntersectionFinderAdder intFinderAdder = new InteriorIntersectionFinderAdder(li);
        this.noder.setSegmentIntersector(intFinderAdder);
        this.noder.computeNodes(segStrings);
        return intFinderAdder.getInteriorIntersections();
    }

    private void computeIntersectionSnaps(Collection snapPts) {
        for (Coordinate snapPt : snapPts) {
            HotPixel hotPixel = new HotPixel(snapPt, this.scaleFactor);
            this.pointSnapper.snap(hotPixel);
        }
    }

    public void computeVertexSnaps(Collection edges) {
        for (NodedSegmentString edge0 : edges) {
            this.computeVertexSnaps(edge0);
        }
    }

    private void computeVertexSnaps(NodedSegmentString e) {
        Coordinate[] pts0 = e.getCoordinates();
        for (int i = 0; i < pts0.length; ++i) {
            HotPixel hotPixel = new HotPixel(pts0[i], this.scaleFactor);
            boolean isNodeAdded = this.pointSnapper.snap(hotPixel, e, i);
            if (!isNodeAdded) continue;
            e.addIntersection(pts0[i], i);
        }
    }
}

