/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.operation.overlay;

import com.databricks.internal.jts.algorithm.PointLocator;
import com.databricks.internal.jts.geom.GeometryFactory;
import com.databricks.internal.jts.geom.LineString;
import com.databricks.internal.jts.geomgraph.DirectedEdge;
import com.databricks.internal.jts.geomgraph.DirectedEdgeStar;
import com.databricks.internal.jts.geomgraph.Edge;
import com.databricks.internal.jts.geomgraph.Label;
import com.databricks.internal.jts.geomgraph.Node;
import com.databricks.internal.jts.operation.overlay.OverlayOp;
import com.databricks.internal.jts.util.Assert;
import java.util.ArrayList;
import java.util.List;

public class LineBuilder {
    private OverlayOp op;
    private GeometryFactory geometryFactory;
    private PointLocator ptLocator;
    private List lineEdgesList = new ArrayList();
    private List resultLineList = new ArrayList();

    public LineBuilder(OverlayOp op, GeometryFactory geometryFactory, PointLocator ptLocator) {
        this.op = op;
        this.geometryFactory = geometryFactory;
        this.ptLocator = ptLocator;
    }

    public List build(int opCode) {
        this.findCoveredLineEdges();
        this.collectLines(opCode);
        this.buildLines(opCode);
        return this.resultLineList;
    }

    private void findCoveredLineEdges() {
        for (Node node : this.op.getGraph().getNodes()) {
            ((DirectedEdgeStar)node.getEdges()).findCoveredLineEdges();
        }
        for (DirectedEdge de : this.op.getGraph().getEdgeEnds()) {
            Edge e = de.getEdge();
            if (!de.isLineEdge() || e.isCoveredSet()) continue;
            boolean isCovered = this.op.isCoveredByA(de.getCoordinate());
            e.setCovered(isCovered);
        }
    }

    private void collectLines(int opCode) {
        for (DirectedEdge de : this.op.getGraph().getEdgeEnds()) {
            this.collectLineEdge(de, opCode, this.lineEdgesList);
            this.collectBoundaryTouchEdge(de, opCode, this.lineEdgesList);
        }
    }

    private void collectLineEdge(DirectedEdge de, int opCode, List edges) {
        Label label = de.getLabel();
        Edge e = de.getEdge();
        if (de.isLineEdge() && !de.isVisited() && OverlayOp.isResultOfOp(label, opCode) && !e.isCovered()) {
            edges.add(e);
            de.setVisitedEdge(true);
        }
    }

    private void collectBoundaryTouchEdge(DirectedEdge de, int opCode, List edges) {
        Label label = de.getLabel();
        if (de.isLineEdge()) {
            return;
        }
        if (de.isVisited()) {
            return;
        }
        if (de.isInteriorAreaEdge()) {
            return;
        }
        if (de.getEdge().isInResult()) {
            return;
        }
        Assert.isTrue(!de.isInResult() && !de.getSym().isInResult() || !de.getEdge().isInResult());
        if (OverlayOp.isResultOfOp(label, opCode) && opCode == 1) {
            edges.add(de.getEdge());
            de.setVisitedEdge(true);
        }
    }

    private void buildLines(int opCode) {
        for (Edge e : this.lineEdgesList) {
            LineString line = this.geometryFactory.createLineString(e.getCoordinates());
            this.resultLineList.add(line);
            e.setInResult(true);
        }
    }

    private void labelIsolatedLines(List edgesList) {
        for (Edge e : edgesList) {
            Label label = e.getLabel();
            if (!e.isIsolated()) continue;
            if (label.isNull(0)) {
                this.labelIsolatedLine(e, 0);
                continue;
            }
            this.labelIsolatedLine(e, 1);
        }
    }

    private void labelIsolatedLine(Edge e, int targetIndex) {
        int loc = this.ptLocator.locate(e.getCoordinate(), this.op.getArgGeometry(targetIndex));
        e.getLabel().setLocation(targetIndex, loc);
    }
}

