/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.nimbusds.jose.crypto;

import com.databricks.internal.nimbusds.jose.CriticalHeaderParamsAware;
import com.databricks.internal.nimbusds.jose.JOSEException;
import com.databricks.internal.nimbusds.jose.JWEAlgorithm;
import com.databricks.internal.nimbusds.jose.JWEDecrypter;
import com.databricks.internal.nimbusds.jose.JWEHeader;
import com.databricks.internal.nimbusds.jose.KeyLengthException;
import com.databricks.internal.nimbusds.jose.crypto.impl.AAD;
import com.databricks.internal.nimbusds.jose.crypto.impl.AlgorithmSupportMessage;
import com.databricks.internal.nimbusds.jose.crypto.impl.ContentCryptoProvider;
import com.databricks.internal.nimbusds.jose.crypto.impl.CriticalHeaderParamsDeferral;
import com.databricks.internal.nimbusds.jose.crypto.impl.DirectCryptoProvider;
import com.databricks.internal.nimbusds.jose.crypto.impl.JWEHeaderValidation;
import com.databricks.internal.nimbusds.jose.jwk.OctetSequenceKey;
import com.databricks.internal.nimbusds.jose.shaded.jcip.ThreadSafe;
import com.databricks.internal.nimbusds.jose.util.Base64URL;
import java.util.Set;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

@ThreadSafe
public class DirectDecrypter
extends DirectCryptoProvider
implements JWEDecrypter,
CriticalHeaderParamsAware {
    private final boolean promiscuousMode;
    private final CriticalHeaderParamsDeferral critPolicy = new CriticalHeaderParamsDeferral();

    public DirectDecrypter(SecretKey key) throws KeyLengthException {
        this(key, false);
    }

    public DirectDecrypter(SecretKey key, boolean promiscuousMode) throws KeyLengthException {
        super(key);
        this.promiscuousMode = promiscuousMode;
    }

    public DirectDecrypter(byte[] keyBytes) throws KeyLengthException {
        this((SecretKey)new SecretKeySpec(keyBytes, "AES"), false);
    }

    public DirectDecrypter(OctetSequenceKey octJWK) throws KeyLengthException {
        this(octJWK.toSecretKey("AES"));
    }

    public DirectDecrypter(SecretKey key, Set<String> defCritHeaders) throws KeyLengthException {
        this(key, defCritHeaders, false);
    }

    public DirectDecrypter(SecretKey key, Set<String> defCritHeaders, boolean promiscuousMode) throws KeyLengthException {
        super(key);
        this.critPolicy.setDeferredCriticalHeaderParams(defCritHeaders);
        this.promiscuousMode = promiscuousMode;
    }

    @Override
    public Set<String> getProcessedCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    @Override
    public Set<String> getDeferredCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    @Deprecated
    public byte[] decrypt(JWEHeader header, Base64URL encryptedKey, Base64URL iv, Base64URL cipherText, Base64URL authTag) throws JOSEException {
        return this.decrypt(header, encryptedKey, iv, cipherText, authTag, AAD.compute(header));
    }

    @Override
    public byte[] decrypt(JWEHeader header, Base64URL encryptedKey, Base64URL iv, Base64URL cipherText, Base64URL authTag, byte[] aad) throws JOSEException {
        if (!this.promiscuousMode) {
            JWEAlgorithm alg = JWEHeaderValidation.getAlgorithmAndEnsureNotNull(header);
            if (!alg.equals(JWEAlgorithm.DIR)) {
                throw new JOSEException(AlgorithmSupportMessage.unsupportedJWEAlgorithm(alg, SUPPORTED_ALGORITHMS));
            }
            if (encryptedKey != null) {
                throw new JOSEException("Unexpected present JWE encrypted key");
            }
        }
        if (iv == null) {
            throw new JOSEException("Unexpected present JWE initialization vector (IV)");
        }
        if (authTag == null) {
            throw new JOSEException("Missing JWE authentication tag");
        }
        this.critPolicy.ensureHeaderPasses(header);
        return ContentCryptoProvider.decrypt(header, aad, null, iv, cipherText, authTag, this.getKey(), this.getJCAContext());
    }
}

