/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.core.oauth;

import com.databricks.internal.fasterxml.jackson.databind.ObjectMapper;
import com.databricks.internal.sdk.core.CredentialsProvider;
import com.databricks.internal.sdk.core.DatabricksConfig;
import com.databricks.internal.sdk.core.oauth.AuthParameterPosition;
import com.databricks.internal.sdk.core.oauth.CachedTokenSource;
import com.databricks.internal.sdk.core.oauth.ClientCredentials;
import com.databricks.internal.sdk.core.oauth.OAuthHeaderFactory;
import com.databricks.internal.sdk.core.utils.AzureUtils;
import com.databricks.internal.slf4j.Logger;
import com.databricks.internal.slf4j.LoggerFactory;
import java.util.HashMap;

public class AzureServicePrincipalCredentialsProvider
implements CredentialsProvider {
    private static final Logger logger = LoggerFactory.getLogger(AzureServicePrincipalCredentialsProvider.class);
    private final ObjectMapper mapper = new ObjectMapper();
    private String tenantId;

    @Override
    public String authType() {
        return "azure-client-secret";
    }

    @Override
    public OAuthHeaderFactory configure(DatabricksConfig config) {
        if (!config.isAzure() || config.getAzureClientId() == null || config.getAzureClientSecret() == null) {
            return null;
        }
        try {
            this.tenantId = config.getAzureTenantId() != null ? config.getAzureTenantId() : AzureUtils.inferTenantId(config);
        }
        catch (Exception e) {
            logger.warn("Failed to infer Azure tenant ID: {}", (Object)e.getMessage());
            return null;
        }
        AzureUtils.ensureHostPresent(config, this.mapper, this::tokenSourceFor);
        CachedTokenSource inner = this.tokenSourceFor(config, config.getEffectiveAzureLoginAppId());
        CachedTokenSource cloud = this.tokenSourceFor(config, config.getAzureEnvironment().getServiceManagementEndpoint());
        return OAuthHeaderFactory.fromSuppliers(inner::getToken, () -> {
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", "Bearer " + inner.getToken().getAccessToken());
            AzureUtils.addWorkspaceResourceId(config, headers);
            AzureUtils.addSpManagementToken(cloud, headers);
            return headers;
        });
    }

    private CachedTokenSource tokenSourceFor(DatabricksConfig config, String resource) {
        String aadEndpoint = config.getAzureEnvironment().getActiveDirectoryEndpoint();
        String tokenUrl = aadEndpoint + this.tenantId + "/oauth2/token";
        HashMap<String, String> endpointParams = new HashMap<String, String>();
        endpointParams.put("resource", resource);
        ClientCredentials clientCredentials = new ClientCredentials.Builder().withHttpClient(config.getHttpClient()).withClientId(config.getAzureClientId()).withClientSecret(config.getAzureClientSecret()).withTokenUrl(tokenUrl).withEndpointParametersSupplier(() -> endpointParams).withAuthParameterPosition(AuthParameterPosition.BODY).build();
        return new CachedTokenSource.Builder(clientCredentials).setAsyncDisabled(config.getDisableAsyncTokenRefresh()).build();
    }
}

