/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.mixin;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SemVer
implements Comparable<SemVer> {
    public final int major;
    public final int minor;
    public final int patch;
    public final String preRelease;
    public final String build;
    private static final Pattern _pattern = Pattern.compile("^(?<major>0|[1-9]\\d*)\\.(?<minor>x|0|[1-9]\\d*)\\.(?<patch>x|0|[1-9x]\\d*)(?:-(?<preRelease>(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+(?<build>[0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$");

    public SemVer(int major, int minor, int patch, String preRelease, String build) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.preRelease = preRelease;
        this.build = build;
    }

    public static SemVer parse(String v) {
        Matcher m4;
        if (v == null || v.isEmpty()) {
            throw new IllegalArgumentException("Not a valid SemVer: " + v);
        }
        if (v.charAt(0) != 'v') {
            v = "v" + v;
        }
        if (!(m4 = _pattern.matcher(v.substring(1))).matches()) {
            throw new IllegalArgumentException("Not a valid SemVer: " + v);
        }
        String minor = m4.group("minor");
        String patch = m4.group("patch");
        return new SemVer(Integer.parseInt(m4.group("major")), "x".equals(minor) ? 0 : Integer.parseInt(minor), "x".equals(patch) ? 0 : Integer.parseInt(patch), m4.group("preRelease"), m4.group("build"));
    }

    @Override
    public int compareTo(SemVer other) {
        if (other == null) {
            return 1;
        }
        if (this.major != other.major) {
            return Integer.compare(this.major, other.major);
        }
        if (this.minor != other.minor) {
            return Integer.compare(this.minor, other.minor);
        }
        if (this.patch != other.patch) {
            return Integer.compare(this.patch, other.patch);
        }
        if (this.preRelease == null && other.preRelease == null) {
            return 0;
        }
        if (this.preRelease == null) {
            return 1;
        }
        if (other.preRelease == null) {
            return -1;
        }
        return this.preRelease.compareTo(other.preRelease);
    }
}

