/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.common.lro;

import java.time.Duration;
import java.util.Objects;
import java.util.Optional;

public class LroOptions {
    private final Optional<Duration> timeout;

    private LroOptions(Builder builder) {
        this.timeout = Optional.ofNullable(builder.timeout);
    }

    public Optional<Duration> getTimeout() {
        return this.timeout;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static LroOptions withTimeout(Duration timeout) {
        return LroOptions.newBuilder().setTimeout(timeout).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LroOptions that = (LroOptions)o;
        return Objects.equals(this.timeout, that.timeout);
    }

    public int hashCode() {
        return Objects.hash(this.timeout);
    }

    public String toString() {
        return "LroOptions{ timeout= " + this.timeout + " }";
    }

    public static class Builder {
        private Duration timeout;

        public Builder setTimeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public LroOptions build() {
            return new LroOptions(this);
        }
    }
}

