/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.sdk.service.iam;

import com.databricks.internal.sdk.core.ApiClient;
import com.databricks.internal.sdk.core.DatabricksException;
import com.databricks.internal.sdk.core.http.Request;
import com.databricks.internal.sdk.service.iam.DeleteUserRequest;
import com.databricks.internal.sdk.service.iam.GetPasswordPermissionLevelsResponse;
import com.databricks.internal.sdk.service.iam.GetUserRequest;
import com.databricks.internal.sdk.service.iam.ListUsersRequest;
import com.databricks.internal.sdk.service.iam.ListUsersResponse;
import com.databricks.internal.sdk.service.iam.PartialUpdate;
import com.databricks.internal.sdk.service.iam.PasswordPermissions;
import com.databricks.internal.sdk.service.iam.PasswordPermissionsRequest;
import com.databricks.internal.sdk.service.iam.User;
import com.databricks.internal.sdk.service.iam.UsersService;
import com.databricks.internal.sdk.support.Generated;
import java.io.IOException;

@Generated
class UsersImpl
implements UsersService {
    private final ApiClient apiClient;

    public UsersImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public User create(User request) {
        String path = "/api/2.0/preview/scim/v2/Users";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, User.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeleteUserRequest request) {
        String path = String.format("/api/2.0/preview/scim/v2/Users/%s", request.getId());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public User get(GetUserRequest request) {
        String path = String.format("/api/2.0/preview/scim/v2/Users/%s", request.getId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, User.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public GetPasswordPermissionLevelsResponse getPermissionLevels() {
        String path = "/api/2.0/permissions/authorization/passwords/permissionLevels";
        try {
            Request req = new Request("GET", path);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, GetPasswordPermissionLevelsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public PasswordPermissions getPermissions() {
        String path = "/api/2.0/permissions/authorization/passwords";
        try {
            Request req = new Request("GET", path);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, PasswordPermissions.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListUsersResponse list(ListUsersRequest request) {
        String path = "/api/2.0/preview/scim/v2/Users";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListUsersResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void patch(PartialUpdate request) {
        String path = String.format("/api/2.0/preview/scim/v2/Users/%s", request.getId());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Content-Type", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public PasswordPermissions setPermissions(PasswordPermissionsRequest request) {
        String path = "/api/2.0/permissions/authorization/passwords";
        try {
            Request req = new Request("PUT", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, PasswordPermissions.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void update(User request) {
        String path = String.format("/api/2.0/preview/scim/v2/Users/%s", request.getId());
        try {
            Request req = new Request("PUT", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Content-Type", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public PasswordPermissions updatePermissions(PasswordPermissionsRequest request) {
        String path = "/api/2.0/permissions/authorization/passwords";
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, PasswordPermissions.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

