/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.algorithm;

import com.databricks.internal.jts.algorithm.Orientation;
import com.databricks.internal.jts.geom.Coordinate;
import com.databricks.internal.jts.geom.CoordinateSequence;

public class RayCrossingCounter {
    private Coordinate p;
    private int crossingCount = 0;
    private boolean isPointOnSegment = false;

    public static int locatePointInRing(Coordinate p, Coordinate[] ring) {
        RayCrossingCounter counter = new RayCrossingCounter(p);
        for (int i = 1; i < ring.length; ++i) {
            Coordinate p1 = ring[i];
            Coordinate p2 = ring[i - 1];
            counter.countSegment(p1, p2);
            if (!counter.isOnSegment()) continue;
            return counter.getLocation();
        }
        return counter.getLocation();
    }

    public static int locatePointInRing(Coordinate p, CoordinateSequence ring) {
        RayCrossingCounter counter = new RayCrossingCounter(p);
        Coordinate p1 = new Coordinate();
        Coordinate p2 = new Coordinate();
        for (int i = 1; i < ring.size(); ++i) {
            p1.x = ring.getOrdinate(i, 0);
            p1.y = ring.getOrdinate(i, 1);
            p2.x = ring.getOrdinate(i - 1, 0);
            p2.y = ring.getOrdinate(i - 1, 1);
            counter.countSegment(p1, p2);
            if (!counter.isOnSegment()) continue;
            return counter.getLocation();
        }
        return counter.getLocation();
    }

    public RayCrossingCounter(Coordinate p) {
        this.p = p;
    }

    public void countSegment(Coordinate p1, Coordinate p2) {
        if (p1.x < this.p.x && p2.x < this.p.x) {
            return;
        }
        if (this.p.x == p2.x && this.p.y == p2.y) {
            this.isPointOnSegment = true;
            return;
        }
        if (p1.y == this.p.y && p2.y == this.p.y) {
            double minx = p1.x;
            double maxx = p2.x;
            if (minx > maxx) {
                minx = p2.x;
                maxx = p1.x;
            }
            if (this.p.x >= minx && this.p.x <= maxx) {
                this.isPointOnSegment = true;
            }
            return;
        }
        if (p1.y > this.p.y && p2.y <= this.p.y || p2.y > this.p.y && p1.y <= this.p.y) {
            int orient = Orientation.index(p1, p2, this.p);
            if (orient == 0) {
                this.isPointOnSegment = true;
                return;
            }
            if (p2.y < p1.y) {
                orient = -orient;
            }
            if (orient == 1) {
                ++this.crossingCount;
            }
        }
    }

    public int getCount() {
        return this.crossingCount;
    }

    public boolean isOnSegment() {
        return this.isPointOnSegment;
    }

    public int getLocation() {
        if (this.isPointOnSegment) {
            return 1;
        }
        if (this.crossingCount % 2 == 1) {
            return 0;
        }
        return 2;
    }

    public boolean isPointInPolygon() {
        return this.getLocation() != 2;
    }
}

