/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.geom;

import com.databricks.internal.jts.geom.CoordinateSequence;
import java.util.Comparator;

public class CoordinateSequenceComparator
implements Comparator {
    protected int dimensionLimit;

    public static int compare(double a, double b) {
        if (a < b) {
            return -1;
        }
        if (a > b) {
            return 1;
        }
        if (Double.isNaN(a)) {
            if (Double.isNaN(b)) {
                return 0;
            }
            return -1;
        }
        if (Double.isNaN(b)) {
            return 1;
        }
        return 0;
    }

    public CoordinateSequenceComparator() {
        this.dimensionLimit = Integer.MAX_VALUE;
    }

    public CoordinateSequenceComparator(int dimensionLimit) {
        this.dimensionLimit = dimensionLimit;
    }

    public int compare(Object o1, Object o2) {
        int i;
        int minDim;
        CoordinateSequence s1 = (CoordinateSequence)o1;
        CoordinateSequence s2 = (CoordinateSequence)o2;
        int size1 = s1.size();
        int size2 = s2.size();
        int dim1 = s1.getDimension();
        int dim2 = s2.getDimension();
        if (dim2 < (minDim = dim1)) {
            minDim = dim2;
        }
        boolean dimLimited = false;
        if (this.dimensionLimit <= minDim) {
            minDim = this.dimensionLimit;
            dimLimited = true;
        }
        if (!dimLimited) {
            if (dim1 < dim2) {
                return -1;
            }
            if (dim1 > dim2) {
                return 1;
            }
        }
        for (i = 0; i < size1 && i < size2; ++i) {
            int ptComp = this.compareCoordinate(s1, s2, i, minDim);
            if (ptComp == 0) continue;
            return ptComp;
        }
        if (i < size1) {
            return 1;
        }
        if (i < size2) {
            return -1;
        }
        return 0;
    }

    protected int compareCoordinate(CoordinateSequence s1, CoordinateSequence s2, int i, int dimension) {
        for (int d = 0; d < dimension; ++d) {
            double ord2;
            double ord1 = s1.getOrdinate(i, d);
            int comp = CoordinateSequenceComparator.compare(ord1, ord2 = s2.getOrdinate(i, d));
            if (comp == 0) continue;
            return comp;
        }
        return 0;
    }
}

