/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.internal.jts.linearref;

import com.databricks.internal.jts.geom.Coordinate;
import com.databricks.internal.jts.geom.Geometry;
import com.databricks.internal.jts.geom.LineString;
import com.databricks.internal.jts.geom.MultiLineString;
import com.databricks.internal.jts.linearref.ExtractLineByLocation;
import com.databricks.internal.jts.linearref.LinearLocation;
import com.databricks.internal.jts.linearref.LocationIndexOfLine;
import com.databricks.internal.jts.linearref.LocationIndexOfPoint;

public class LocationIndexedLine {
    private Geometry linearGeom;

    public LocationIndexedLine(Geometry linearGeom) {
        this.linearGeom = linearGeom;
        this.checkGeometryType();
    }

    private void checkGeometryType() {
        if (!(this.linearGeom instanceof LineString) && !(this.linearGeom instanceof MultiLineString)) {
            throw new IllegalArgumentException("Input geometry must be linear");
        }
    }

    public Coordinate extractPoint(LinearLocation index) {
        return index.getCoordinate(this.linearGeom);
    }

    public Coordinate extractPoint(LinearLocation index, double offsetDistance) {
        LinearLocation indexLow = index.toLowest(this.linearGeom);
        return indexLow.getSegment(this.linearGeom).pointAlongOffset(indexLow.getSegmentFraction(), offsetDistance);
    }

    public Geometry extractLine(LinearLocation startIndex, LinearLocation endIndex) {
        return ExtractLineByLocation.extract(this.linearGeom, startIndex, endIndex);
    }

    public LinearLocation indexOf(Coordinate pt) {
        return LocationIndexOfPoint.indexOf(this.linearGeom, pt);
    }

    public LinearLocation indexOfAfter(Coordinate pt, LinearLocation minIndex) {
        return LocationIndexOfPoint.indexOfAfter(this.linearGeom, pt, minIndex);
    }

    public LinearLocation[] indicesOf(Geometry subLine) {
        return LocationIndexOfLine.indicesOf(this.linearGeom, subLine);
    }

    public LinearLocation project(Coordinate pt) {
        return LocationIndexOfPoint.indexOf(this.linearGeom, pt);
    }

    public LinearLocation getStartIndex() {
        return new LinearLocation();
    }

    public LinearLocation getEndIndex() {
        return LinearLocation.getEndLocation(this.linearGeom);
    }

    public boolean isValidIndex(LinearLocation index) {
        return index.isValid(this.linearGeom);
    }

    public LinearLocation clampIndex(LinearLocation index) {
        LinearLocation loc = index.copy();
        loc.clamp(this.linearGeom);
        return loc;
    }
}

